#include <stdio.h>
#include <stdlib.h>
#include "rsa.h"
#include "rsaref.h"
#include "../base64.h"

void outp(unsigned char*buf, unsigned long len)
{
	unsigned long ret, i;
	char obuf[100];
	ret = base64_encode(obuf, buf, len);
	for(i=0;i<ret;i++) {
		fprintf(stderr, "%c", obuf[i]);
	}
}

int main()
{
	R_RSA_PUBLIC_KEY *pubkey;
	R_RSA_PRIVATE_KEY *privkey;
	R_RSA_PROTO_KEY *proto;
	unsigned long ilen=50, olen=50;
	R_RANDOM_STRUCT rand;
	rand.outputAvailable = 16;
	memset(rand.output, 0, 16);

	unsigned char buffer[100];
	unsigned char obuffer[100];
	memset(buffer, 0x33, 50);

	pubkey = (R_RSA_PUBLIC_KEY*) malloc(sizeof(R_RSA_PUBLIC_KEY));
	memset(pubkey, 0x00, sizeof(R_RSA_PUBLIC_KEY));
	privkey = (R_RSA_PRIVATE_KEY*) malloc(sizeof(R_RSA_PRIVATE_KEY));
	memset(privkey, 0x00, sizeof(R_RSA_PRIVATE_KEY));
	proto = (R_RSA_PROTO_KEY*) malloc(sizeof(R_RSA_PROTO_KEY));
	memset(proto, 0x00, sizeof(R_RSA_PROTO_KEY));
	proto->bits=2048;
	proto->useFermat4=0;
	pubkey->bits=2048;

	R_GeneratePEMKeys(pubkey, privkey, proto, NULL);
	fprintf(stderr, "privkey: %d\npubkey: %d\n", privkey->modulus, pubkey->modulus);

fprintf(stderr, "\nbuf before pubenc: "); outp(buffer, 50);

	RSAPublicEncrypt (obuffer, &olen, buffer, 50, pubkey, NULL);

fprintf(stderr, "\nbuf after pubenc: "); outp(obuffer, 50);

//RSAPrivateDecrypt(buffer, &ilen, obuffer, olen, privkey, NULL);
	RSAPublicDecrypt (buffer, &ilen, obuffer, olen, pubkey);

fprintf(stderr, "\nbuf after pubdec: "); outp(buffer, 50);	


	RSAPrivateEncrypt(obuffer, &olen, buffer, 50, privkey);

fprintf(stderr, "\nbuf after privenc: "); outp(obuffer, 50);

	RSAPrivateDecrypt(buffer, &olen, obuffer, 50, privkey, &rand);

fprintf(stderr, "\nbuf after privdec: "); outp(buffer, 50);


return 0;
}

