#################################################
#   Copyright (C) 2005 by Brian Arnold
#   brian@ae6gn.com
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the
#   Free Software Foundation, Inc.,
#   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#################################################

# Form implementation generated from reading ui file 'textwindow.ui'
#
# Created: Thu Oct 27 18:35:50 2005
#      by: The QtRuby User Interface Compiler (rbuic)
#
# WARNING! All changes made in this file will be lost!


#require 'Korundum'

class TextWindow < KDE::Dialog

    slots 'languageChange()',
    'saveEntered()',
    'saveEncyphered()',
    'setEnteredText(text)',
    'setEncypheredText(text)'

    attr_reader :TWentered
    attr_reader :TWencyphered
    attr_reader :kActiveLabel2
    attr_reader :kActiveLabel1


    def initialize(parent = nil, name = nil, modal = false, fl = 0)
        super

        if name.nil?
        	setName("TextWindow")
        end


        @TWentered = KDE::TextBrowser.new(self, "TWentered")
        @TWentered.setGeometry( Qt::Rect.new(10, 70, 370, 140) )
        @TWentered.setWordWrap( KDE::TextBrowser::FixedColumnWidth )
        @TWentered.setWrapColumnOrWidth( 40 )
        @TWentered.setWrapPolicy( KDE::TextBrowser::Anywhere )

        @TWencyphered = KDE::TextBrowser.new(self, "TWencyphered")
        @TWencyphered.setEnabled( true )
        @TWencyphered.setGeometry( Qt::Rect.new(10, 250, 370, 140) )
        @TWencyphered.setWordWrap( KDE::TextBrowser::FixedColumnWidth )
        @TWencyphered.setWrapColumnOrWidth( 40 )
        @TWencyphered.setWrapPolicy( KDE::TextBrowser::Anywhere )

        @kActiveLabel2 = KDE::ActiveLabel.new(self, "kActiveLabel2")
        @kActiveLabel2.setGeometry( Qt::Rect.new(10, 48, 116, 22) )

        @kActiveLabel1 = KDE::ActiveLabel.new(self, "kActiveLabel1")
        @kActiveLabel1.setGeometry( Qt::Rect.new(10, 228, 144, 22) )


        @saveEnteredAction = Qt::Action.new(self, "saveEnteredAction")
        @saveEncypheredAction = Qt::Action.new(self, "saveEncypheredAction")

        @clearEnteredAction = Qt::Action.new(self, "clearEnteredAction")
        @clearEncypheredAction = Qt::Action.new(self, "clearEncypheredAction")
        @clearAllAction = Qt::Action.new(self, "clearAllAction")

        @MenuBar = Qt::MenuBar.new( self, "MenuBar" )


        @Save = Qt::PopupMenu.new( self )
        @saveEnteredAction.addTo( @Save )
        @saveEncypheredAction.addTo( @Save )
        @MenuBar.insertItem( "", @Save, 1 )

        @Clear = Qt::PopupMenu.new( self )
        @clearEnteredAction.addTo( @Clear )
        @clearEncypheredAction.addTo( @Clear )
        @Clear.insertSeparator()
        @clearAllAction.addTo( @Clear )
        @MenuBar.insertItem( "", @Clear, 2 )

        languageChange()
        resize( Qt::Size.new(390, 401).expandedTo(minimumSizeHint()) )
        clearWState( WState_Polished )


        Qt::Object.connect(@saveEnteredAction, SIGNAL("activated()"), self, SLOT("saveEntered()") )
        Qt::Object.connect(@saveEncypheredAction, SIGNAL("activated()"), self, SLOT("saveEncyphered()") )
        Qt::Object.connect(@clearAllAction, SIGNAL("activated()"), @TWentered, SLOT("clear()") )
        Qt::Object.connect(@clearAllAction, SIGNAL("activated()"), @TWencyphered, SLOT("clear()") )
        Qt::Object.connect(@clearEnteredAction, SIGNAL("activated()"), @TWentered, SLOT("clear()") )
        Qt::Object.connect(@clearEncypheredAction, SIGNAL("activated()"), @TWencyphered, SLOT("clear()") )
    end

    #
    #  Sets the strings of the subwidgets using the current
    #  language.
    #
    def languageChange()
        setCaption(trUtf8("Text Window - KEnigma"))
        @TWencyphered.setText( nil )
        @kActiveLabel2.setText( trUtf8("Entered Text:") )
        @kActiveLabel1.setText( trUtf8("Encyphered Text:") )
        @saveEnteredAction.setText(trUtf8("Save the text in the Entered Text box"))
        @saveEnteredAction.setMenuText(trUtf8("Entered"))
        @saveEncypheredAction.setText(trUtf8("Save the text in the Entered Text box"))
        @saveEncypheredAction.setMenuText(trUtf8("Encyphered"))
        @clearEnteredAction.setText(trUtf8("Clear the entered text box."))
        @clearEnteredAction.setMenuText(trUtf8("Entered"))
        @clearEncypheredAction.setText(trUtf8("Clear the encyphered text box."))
        @clearEncypheredAction.setMenuText(trUtf8("Encyphered"))
        @clearAllAction.setText(trUtf8("Clear the all the text boxes."))
        @clearAllAction.setMenuText(trUtf8("All"))
        if !@MenuBar.findItem(1).nil?
                @MenuBar.findItem(1).setText( trUtf8("&Save to File") )
        end
        if !@MenuBar.findItem(2).nil?
                @MenuBar.findItem(2).setText( trUtf8("&Clear") )
        end
    end
    protected :languageChange


    def saveEntered()
      @FileName = KDE::FileDialog.getSaveFileName("./enteredData.txt", "*.txt|(*.txt) Text Files")
      if @FileName and !@FileName.empty? then
        f = KDE::SaveFile.new(@FileName)
        f.textStream << @TWentered.text
        f.close
        @FileName = ""
      end
    end

    def saveEncyphered()
      @FileName = KDE::FileDialog.getSaveFileName("./encypheredData.txt", "*.txt|(*.txt) Text Files")
      if @FileName and !@FileName.empty? then
        f = KDE::SaveFile.new(@FileName)
        f.textStream << @TWencyphered.text
        f.close
        @FileName = ""
      end
    end


    def setEnteredText(text)
      oldtext = @TWentered.text
      text = oldtext + text
      @TWentered.setText(text)
    end

    def setEncypheredText(text)
      oldtext = @TWencyphered.text
      text = oldtext + text
      @TWencyphered.setText(text)
    end

end
