/***************************************************************************
                          main.c  -  experimental frontend for the encrypting
                          decrypting engine.
                             -------------------
    begin                : Thu Nov 16 16:59:50 EST 2000
    copyright            : (C) 2000 by Brian Wagener and Katrina Illari
    email                : CptanPanic@users.sourceforge.net


    Patch:  Dale Amon <amon@vnl.com>
            cryptEncode unconditionally free'd keyfile. Fixed it.

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <globaldefs.h>
#include <rijndael-api-fst.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <crypt.h>

#define FILENAMESIZE 100

extern int interactive;

strc cryptEncode(stword32 nb, stword32 nk, char *keyfile ,
		 FILE *fin, FILE *fout){
  keyInstance key;
  unsigned char *pKey;
  cipherInstance cipher;
  char inbuff[MAX_NB/8], outbuff[MAX_NB/8];
  int rc;

 
  pKey = malloc(nk/8*2); /* Note that the key is twice as big as the key length
			   because we store a binary byte using 2 ascii chars
			   as nibbles*/
   
  // Get key filename, if it wasn't read on command line, 
  // either prompt for one, or create on.
  if( !keyfile ){
    keyfile = malloc(sizeof(char) * FILENAMESIZE );
    if( interactive ){
      fprintf(stderr,"Enter key filename: ");
      scanf("%s",keyfile);
    } else { //For now create key filename using time().
      sprintf(keyfile,"keyfile.%i",(int)time(NULL));
      createKey(nk,pKey,keyfile);
      fprintf(stderr,"The %d bit key created is %s \n",(int)nk, keyfile);
    }    
    nk = readKey(pKey, keyfile);
    free(keyfile);
  } else {
    nk = readKey(pKey, keyfile); 
  }
  

  if( !nk) {
    fprintf(stderr,"Error Reading in Key\n");
    exit( EXIT_FAILURE);
  }

  if ( !(rc = makeKey(&key, DIR_ENCRYPT, nk, pKey)) ){
    fprintf(stderr, "Failure to initialize key with error code %d\n", rc);
    free(pKey);
    return FAILURE;
  }
  if (cipherInit(&cipher, MODE_CBC, NULL)!=TRUE){
    fprintf(stderr, "Failure to initialize cipher\n");
    free(pKey);
    return FAILURE;
  }
  
  
  fprintf(fout,"%s ",keyfile);
  fwrite(&nb, sizeof (stword32), 1, fout); // Store blocksize


  while(fread(inbuff, 1, nb/8, fin)){
    memset(outbuff, 0, sizeof(outbuff));
    rc=blockEncrypt(&cipher, &key, inbuff, nb, outbuff);
    if (rc != nb)
      return FAILURE;
    fwrite(outbuff, 1, nb/8, fout);
    memset(inbuff, 0, sizeof(inbuff));

  }

  fclose(fout);
  fclose(fin);
  free(pKey);
  return SUCCESS;
}

strc cryptDecode(stword32 nk, char *keyfile, FILE *fin, FILE *fout){
  keyInstance key;
  unsigned char *pKey;
  cipherInstance cipher;
  char inbuff[MAX_NB/8], outbuff[MAX_NB/8];
  stword32 nb, realDataSize;
  char str[FILENAMESIZE];
  
  
  pKey = malloc(nk/8*2); /* Note that the key is twice as big as the key length
			   because we store a binary byte using 2 ascii chars
			   as nibbles*/


  
  if( !keyfile ){
    keyfile = malloc(sizeof(char) * FILENAMESIZE );
    fscanf(fin,"%s ",keyfile); 
    fprintf(stderr,"The keyname found was %s\n",keyfile);
    nk = readKey(pKey, keyfile);
    fprintf(stderr,"The %i bit key read in is %s \n", (int)nk, keyfile);
    free(keyfile);
  } else {
    nk = readKey(pKey, keyfile);
    fscanf(fin,"%s ",str); 
  }
  

  if (makeKey(&key, DIR_DECRYPT, nk, pKey)!=TRUE)
    {
      fprintf(stderr,"SECTAR: Error initializing key\n");
      return FAILURE;
    }
  if (cipherInit(&cipher, MODE_CBC, NULL)!=TRUE)
    {
      fprintf(stderr,"SECTAR: Error initializing cipher\n");
      return FAILURE;
    }
  
  fread(&nb, sizeof (stword32), 1, fin);
  fprintf(stderr,"Blocksize is %d\n",(int)nb);

  while(fread(inbuff, 1, nb/8, fin)){
    memset(outbuff,0,sizeof(outbuff));
    if (blockDecrypt(&cipher, &key, inbuff, nb, outbuff)!= nb)
      return (FAILURE);
    /*    realDataSize=(filesize/(nb/8))?nb/8:filesize;
	  filesize-=realDataSize;
	  fwrite(outbuff, 1, realDataSize, fout);
    */
    fwrite(outbuff, 1, nb/8, fout);
  }
  
  fclose(fout);
  fclose(fin);
  free(pKey);
  return SUCCESS;
}

int createKey(int nk, unsigned char *key, char *keyfile){
  FILE *fout = 0;
  int i;
  unsigned char buf;

  if ((fout = fopen (keyfile, "w")))
    {
      FILE *ran;
      if ((ran=fopen ("/dev/random", "r"))==NULL){
	fprintf(stderr, "Could not open random device\n");
	return EXIT_FAILURE;
      }

      for (i = 0; i < nk/8*2; i +=2) {
	char t, j;

	if ( !fread(&buf, 1, 1, ran ) ){
	  fprintf(stderr, "Error in making key\n"
		  "Coudn't read from /dev/random\n");
	  return EXIT_FAILURE;
	}

	t = (buf & 0xf0) >> 4;
	j = t + 0x30;
	if( t > 0x9 ) j = t + 0x37;
	key[i] = j;
			
	t = buf & 0x0f ;
	j = t + 0x30;
	if( t > 0x9 ) j = t + 0x37;
	key[i+1] = j;
      }
      
      fwrite(key, 1, nk/8 * 2, fout); // Write entire key to file.
      fclose(fout);
      fclose(ran);
    }else{
      fprintf(stderr,"Could not create key file\n");
      return EXIT_FAILURE;
    }
  return nk;
}

int readKey(unsigned char *key, char *file){
  FILE *fin;
  int nk, rc;
  
  
  if ( (fin = fopen (file, "r"))) {
    fseek(fin, 0, SEEK_END);  // Block gets filesize to be used in header.
    nk = ftell(fin) ;	// This is the keysize since we are using 2 bytes to store 8 bits.
    nk = nk * 4;
    fseek(fin, 0, SEEK_SET);
    rc = fread(key,1,nk/8*2,fin);
    if( rc != nk/8 * 2){
      fprintf(stderr, "Error: Unable to read in entire key read in %d of %d\n",rc,nk);
      return EXIT_FAILURE;
    } else if ( nk != 128 && nk != 198 && nk != 256 ){
      fprintf(stderr,"Error: %d Key read in was not valid size, must be 128,192 or 256\n",nk);
      return EXIT_FAILURE;
    }
    fclose(fin);  	
    
  } else {
    fprintf(stderr,"Could not open key file\n");
    return EXIT_FAILURE;
  }
  return nk;
}

