#!/bin/sh
# test script for srm

BS=123
SRC=/dev/zero # /dev/urandom
SRM=-s

if [ ! -c $SRC ] ; then
    echo $SRC not present or no char device
    exit 1
fi

testsrm()
{
    if [ ! -f $F ] ; then
	echo failed to create $F
	exit 1
    fi
    ls -l $F
    if ! src/srm $SRM $F ; then
	echo failed to secure remove $F
	exit 1
    fi
    if [ -f $F ] ; then
	echo srm was not able to remove $F
	exit 1
    fi
}

F="0.tst"
touch $F
testsrm

# test until ~5GiB
for i in 1 22 333 4444 55555 666666 7777777 44444444 ; do
    F="$i.tst"
    dd if=$SRC of=$F bs=$BS count=$i 2> /dev/null
    testsrm
done

echo all tests successfull
exit 0
