Summary: Another file integrity checker
# The Summary: line should be expanded to about here -----^
Summary(fr): afick, logiciel de controle d'intgrite
Name: afick
Version: 2.12
Release: 1
Group: Applications/System
License: GPL
Source: afick.tar.gz
BuildRoot:  %{_topdir}/installroots/%{name}-%{version}-%{release}
# Following are optional fields
URL: http://afick.sourceforge.net
Packager: Eric Gerbier <gerbier@users.sourceforge.ne>
#Distribution: Red Hat Contrib-Net
#Patch: build.patch
#Prefix: /
BuildArch: noarch
Requires: perl
#%if %perlversion
#Requires: perl-Digest-MD5
#%endif
#Obsoletes: 

%description
afick is a portable file integrity checker
(it only needs standard perl to work).
it will be run daily by cron to detect new/deleted/modified files
It works by first (init) making an snapshot of strategic directories 
attributes, and then compare the disk status with this snapshot.
A Graphical interface is available in afick-gui package.

%description -l fr
afick est un logiciel de controle d'intgrit portable
(il est cod en language perl).
Il permet, par un cron quotidien, de dtecter les fichiers nouveaux/supprim/modifis.
Il travaille en fabriquant une image (init) des repertoires ou fichiers essentiels dans
une base de donne. Le cron compare l'tat du disque avec cette 'image'.
Une interface graphique est disponible dans le package afick-gui.

%prep
%setup -c afick
#%patch

%install
mkdir -p $RPM_BUILD_ROOT
# html doc dir
mkdir html && mv *.html *.gif *.jpg html/
cp -a etc usr var ${RPM_BUILD_ROOT-/}
# for ghost
cd $RPM_BUILD_ROOT && touch var/lib/afick/afick.dir var/lib/afick/afick.pag var/lib/afick/afick.ctr var/lib/afick/history

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf "$RPM_BUILD_ROOT 2> /dev/null"

%pre
#force save old config on upgrade
if [ "$1" = 2 ]
then
	#update
	if [ -f /usr/bin/afick_preinstall.pl ]
	then
		afick_preinstall.pl -c /etc/afick.conf
	else
		cp -f /etc/afick.conf /etc/afick.conf.sav
	fi
	#echo "save old config as /etc/afick.conf.rpmsave"
fi
# check perl version
perlversion=$( perl -e 'if ( $] < 5.008 ){ print 1} else { print 0};' )
if [ $perlversion -eq 1 ]
then
	#check for perl-Digest-MD5
	# in old release, needs an external package
	# but is included in new perl releases
	perl -e 'eval { require Digest::MD5 }; exit 1 if $@'
	if [ $? -eq 1 ]
	then
		echo "afick requires perl-Digest-MD5 package"
		exit
	else
		echo "found perl-Digest-MD5 : ok"
	fi
fi

%post
afick_postinstall.pl -c /etc/afick.conf

%preun

%postun

%files
%defattr(-,root,root)
%doc AUTHORS
%doc Changelog
%doc COPYING
%doc COPYRIGHT
%doc INSTALL
%doc linux.conf
%doc NEWS
%doc README
%doc QUICKSTART
%doc TODO
%doc afick.lsm
%doc html
%config %attr(0600 root root)  /etc/afick.conf
%dir /etc/cron.daily
%config /etc/cron.daily/afick_cron
%dir /etc/logrotate.d
%config /etc/logrotate.d/afick
/usr/bin/afick.pl
/usr/bin/afick
/usr/bin/afick_archive.pl
/usr/bin/afick_archive
/usr/bin/afickonfig.pl
/usr/bin/afickonfig
/usr/bin/afick-common.pl
/usr/bin/afick_postinstall.pl
/usr/bin/afick_preinstall.pl
%doc /usr/share/man/man1/afick.1*
%doc /usr/share/man/man1/afick_archive.1*
%doc /usr/share/man/man1/afickonfig.1*
%doc /usr/share/man/man5/afick.conf.5*
%dir %attr(0700 root root) /var/lib/afick
%ghost /var/lib/afick/afick.pag
%ghost /var/lib/afick/afick.dir
%ghost /var/lib/afick/afick.ctr
%ghost /var/lib/afick/history
%dir %attr(0700 root root) /var/lib/afick/archive
%dir %attr(0700 root root) /var/log/afick/


%package gui
Summary: A graphical interface for afick
# The Summary: line should be expanded to about here -----^
Group: Applications/System
# Following are optional fields
#Distribution: Red Hat Contrib-Net
#Patch: build.patch
#Prefix: /
BuildArch: noarch
Requires:  afick >= 2.0, perl-Tk
Conflicts: afick < 2.0
#Obsoletes: 

%description gui
afick-gui is perl/tk tool for afick software
It can be used to launch afick with differents options
and to have a graphical view of results
It comes with menu for integration in kde/gnome ...

%post gui
if [ -x /usr/bin/update-menus ]; then /usr/bin/update-menus || true ; fi

%postun gui
if [ "$1" = "0" -a -x /usr/bin/update-menus ]; then /usr/bin/update-menus || true ; fi

%files gui 
%defattr(-,root,root)
%doc AUTHORS
%doc Changelog
%doc COPYING
%doc COPYRIGHT
%doc INSTALL
%doc linux.conf
%doc NEWS
%doc README
%doc QUICKSTART
%doc TODO
%doc afick.lsm
%doc html
/usr/bin/afick-tk.pl
/usr/bin/afick-tk
/usr/bin/afick-gui
/usr/share/menu/afick-gui
%dir /usr/share/applnk/
%dir /usr/share/applnk/System/
/usr/share/applnk/System/afick.desktop
%dir /usr/share/gnome/
%dir /usr/share/gnome/apps/
%dir /usr/share/gnome/apps/System/
/usr/share/gnome/apps/System/afick.desktop
/usr/share/icons/afick.xpm
/usr/share/icons/afick.png
%dir /usr/share/pixmaps
/usr/share/pixmaps/afick.xpm
/usr/share/pixmaps/afick.png
%doc /usr/share/man/man1/afick-tk.1*

%changelog
* Wed Oct 16 2008 Eric Gerbier <gerbier@users.sourceforge.net> 2.12-1
- (windows) afick_planning now send report instead summary and use LINES macro
- (unix) fix a warning with perl 5.10 on Constant subroutine main::S_IWGRP redefined
- fix perlcritic warnings
- (unix) new MOUNT macro to use a remote database when using batch task on unix (afick_cron)
- add a security to avoid exlude auto-control files
- better Makefile.pl diagnostics (I hope)

* Tue Apr 10 2008 Eric Gerbier <gerbier@users.sourceforge.net> 2.11-1
- afick_planning can also send a mail on windows (add MAILHOST macro)
- only one doc source : the included pod doc

* Tue May 17 2007 Eric Gerbier <gerbier@users.sourceforge.net> 2.10.1
- post_install can replace environment variables in afick's config
- windows config file now use environment variables (Manuel Martin suggest)
- rename set_planning.bat to afick_postinstall.bat
- display warning for too long acl on windows (SDBM error) 
- add report_syslog directive and option
- dynamic choice of database backend
- change directives compare algorythme (diff_tab sub)
- remove usage sub (all doc in pod)
- add report_url option
- adapt afick_cron to old shell syntax (ash ...) to fix bug with anacron  ( Slass100 report)
- prepare code for daemon mode (with gamin use)
- checksum do not change atime any more if possible
- improved afick change detection (warnings not only on checksum)

* Tue Sep 26 2006 Eric Gerbier <gerbier@users.sourceforge.net> 2.9.1
- fix bug on temporary files (init parameters to 0) ? (afick)
- fix bug for exclude* (multi-line works again, was broken in 2.7-1) (afick-common), thanks Manuel Martin
- use more constants (afick)
- skip checksum on empty files (afick)
- recode addfile in checksum sub to avoid exit (croak) on errors (afick)
- change warning to debug for checksum access on windows (afick)
- updated windows config file (add exclude by Manuel Martin)
- (afickonfig) add man option (first use of Pod::Usage)
- (afickonfig) add opt_ prefix for opt variables
- (afickonfig) for addpath option on windows, add  %systemroot% and %ProgramFiles%
- (afick-gui) : add archive menu
- (afick) fix a bug on exceptions with globing and ignore_case

* Mon Sep 04 2006 Eric Gerbier <gerbier@users.sourceforge.net> 2.9.0
- add database files in rpm database (ghost)
- new warning_def and debug_def default subroutines (afick-common) to avoid duplicate code
- new option --check_update to check for a new version (afick)
- use perlcritic to clean perl code (follow Conway rules)
- rename planning.bat to set_planning.bat and planning.pl to set_planning.pl (windows)
- fix tar.gz install for hpux users (thanks Menguy Jacques)
- fix a bug on print_config option (afick)
- add afick_archive.pl tool
- info, debug, warning now have an internal new line terminator
- tar.gz, debian and rpm install now use common scripts for pre-install and post-install (clean config configuration)
- improved configuration upgrade with "local config section"
- clean_config do not remove comments any more (afick/afickonfig bugfix)
- running an update action on a missing database switch to init action (usefull for batch job)
- change allow_overload default directive value to yes
- addpath and addlib option now work on microsoft os (afickonfig bugfix)

* Fri Jul 07 2006 Eric Gerbier <gerbier@users.sourceforge.net> 2.8.3
- new my_die sub to be consistent (as warning, info ...)
- add a locking mecanism on database (my_lock, my_unlock, close_database sub)
- add new debugging tool ( debug_begin, debug_end, get_caller )
- add signal trapping for a clean exit
- fix bug if macro VERBOSE = 1( no mail sent if no changes) on afick_cron
- nice macro value is used by afick.pl
- change auto_control check for rfc needs
- fix a bug with follow_symlinks doc which does not match behavior
- new windows packager Setup2Go 
- (windows package) save config file before install
- (windows package) remove task from service planning on uninstall
- (windows package) remove hard-coded path to afick directory

* Wed Aug 17 2005 Eric Gerbier <gerbier@users.sourceforge.net> 2.8.2
- default config file can be set in AFICK_CONFIG environment var
- afick-gui can be started by not-root users
- rename afick.cron into afick_cron (cron filename limitation on debian : no dots )

* Mon Jun 06 2005 Eric Gerbier <gerbier@users.sourceforge.net> 2.8.1
- fix date on control file to match history/archive date
- more general addrule sub
- improve auto-control on directives changes
- fix bad directives display, with a new uniq sub (get_list_dir)

* Mon Jun 06 2005 Eric Gerbier <gerbier@users.sourceforge.net> 2.8.0
- restrict permissions on database files
- now add all afick's programs to database
- allow md5 and sha1 checksum
- stat_secu : add uid and gid orphans
- doc translation to french
- Makefile.pl can change shebang (perl path) on perl scripts (suggest from paulhargreaves)
- upgrade from tar.gz now save old config file

* Sun May 01 2005 Eric Gerbier <gerbier@users.sourceforge.net> 2.7.1
- fix problem with mkdir (add -p) on src.rpm (thanks Sinner)
- add real elapsed time in timing option for afick.pl (thanks Roland Friedwagner)
- remove symbolic links from running testing (thanks Roland Friedwagner)
- fix problem with tar.gz install (afickonfig return code)
- fix bug on get_configuration sub for multi-line exclude
- add follow_symlinks directive to have control checksum behavior on symbolic links (Roland Friedwagner)
- add directive allow_overload
- add macro REPORT
- fix bug with root dir on windows (thanks Jean-Marc Mongrelet)
- fix bug for exceptions and quoted files
- (afick-tk)now use get_configuration (from afick_common)
- (afick-tk) add directives configuration menu

* Wed Feb 07 2005 Eric Gerbier <gerbier@users.sourceforge.net> 2.7.0
- add print_directive, print_macro, print_alias, print_rule options
- add addpath and addlib options to afickonfig command
- get macro constant from Fcntl instead POSIX (define socket and links)
- add search option to get a filtered output from database
- add stat_secu and stat_size options
- add tab2hash, get_filemode, get_filesize, is_type, split_record sub
- add open_database, statistics sub
- move rech_parent sub to afick-common
- run afickonfig.pl --addpath --addlib in rpm and tgz install
- change default max_checksum_size to ~ 10 Mo
- fix test_os.sh script perms bug
- better section split in config file
- use same format for all printed dates (last run ...)
- add uninstall target in Makefile for tar.gz installers
- allow new fileinfo fields (add norm_info and is_changed sub)
- (afick-tk) redesign progress window (split files and pourcents)
- (afick-tk) add 2 times window (elapsed, remaining time)
- (afick-tk) in progress mode, reduce the number of update calls
- (afick-tk) add stat_secu, stat_size and search in analysis menu
- (afick-tk) add "addpath/addlib" (afickonfig call) in configuration menu
- (afick-tk) new wrapper sub to allow afickonfig call
- (afick-tk) now use is_microsoft sub (afick-common)

* Wed Jan 13 2005 Eric Gerbier <gerbier@users.sourceforge.net> 2.6.2
- fix a bug on afickonfig with directives
- avoid scan if list mode contains exceptions (rech_parent)
- open database in read-only mode if compare (bug report from Brian Warshawsky)
- do not write control file in compare mode

* Mon Jan 6 2005 Eric Gerbier <gerbier@users.sourceforge.net> 2.6.1
- now create history file, archive dir if not exists
- on window, launch icon is now in afick menu
- add a warning if nothing to scan
- debug and clean list options treatement

* Wed Dec 15 2004 Eric Gerbier  <gerbier@users.sourceforge.net> 2.6.0 
- restrict config file perm (security)
- add max_checksum_size directive for partial checksum on big files (idea from Emmanuel Florac)
- add exclude_re directive for regular expressions filter
- on history, delete change entry color to black (afick-gui)
- change color for deleted from blue to brown (afick-gui)
- move style declare to where it is used (afick-gui)
- change clean history algo (work on one file only) (afick-gui)

* Wed Nov 10 2004 Eric Gerbier <gerbier@users.sourceforge.net> 2.5.0
- fix bug on print_config option
- add alias, macros, rules options on afickonfig
- check config validity at end of afickonfig
- add info on check_config
- now use common lib afick_common.pl
- add option clean_config (afick.pl)
- rewrite alias parsing ( now in good order)
- fix bug in E alias use

* Wed Oct 15 2004 Eric Gerbier <gerbier@users.sourceforge.net> 2.4.0
- change tar.gz for aix
- add short option -A for --archive
- clean rpm files with rpmlint
- now check macro syntaxe (afick.pl)
- fix bug in planning.pl (remove rem)
- add afick_planning.pl to send MessageBox to user on windows from service planning
- test if archive dir exists (afick.pl)
- now can choice day/time for service planning (planning.pl)
- change all dates from gmt to local time
- print_config option now print macros/alias/rules too
- add current version in report header
- add exclude_prefix directive
- rewrite exclude algo to be faster

* Tue Jul 21 2004 Eric Gerbier <gerbier@users.sourceforge.net> 2.3.1
- remove perl-Digest-MD5 dependency to work on recent distrib with perl 5.8
  a perl test is now done in pre-install stage

* Tue Jun 29 2004 Eric Gerbier <gerbier@users.sourceforge.net> 2.3.0 (gui)
- fix bad pourcent display on init (to 0)
- replace configuration buttons by menus

* Tue Jun 29 2004 Eric Gerbier <gerbier@users.sourceforge.net> 2.3.0
- add afickonfig.pl tool to manage afick's config file
- add --database/-D option
- add comments on running options in output
- add check_config option
- rename scan.cmd into afick_scan.cmd
- change print_config output to the same format as config file
- test if exists before adding to service planning on windows
- remove old 'h' attribute (replaced by md5, or sha1)

* Mon May 10 2004 Eric Gerbier <gerbier@users.sourceforge.net> 2.2.0 (gui)
- replace buttons by menus
- add bind keys for quicker actions
- replace double quotes by simple if possible

* Mon May 10 2004 Eric Gerbier <gerbier@users.sourceforge.net> 2.2.0
- replace double quotes by simple if possible
- add the NICE macro to control afick cron job priority
- add the BATCH macro to control afick cron job run
- fix missing file name in print mode
- bug on dangling links, defined as top file in config file ( bad $rep)

* Mon Apr 5 2004 Eric Gerbier <gerbier@users.sourceforge.net> 2.1.0 (gui)
- reference to array in sub
- add history menu for history and archive access
- add colors in text 
- common colors
- now have a common load sub for all entries (pipe or saved files)
- a common sub (display_message) for all helps

* Mon Apr 5 2004 Eric Gerbier <gerbier@users.sourceforge.net> 2.1.0
- reference to array in sub
- new directive debug
- add an eval on FileSecurity to avoid perl crash or warning
- remove -T flag to have same version on all os
- a new Makefile.pl for tgz install (check dependencies)
- fix a bug with --print and archive mode
- add a planning.bat on windows to insert a task in planning

* Wed Mar 3 2004 Eric Gerbier <gerbier@users.sourceforge.net> 2.0.0
- add ignore_case directive/option
- add history directive/option
- add archive directive
- bug in soustractive alias
- remove/clean global var
- split in 2 packages command-line and gui
- add a makefile for tgz package
- add macro VERBOSE to suppress useless mail if no changes

* Tue Jan 28 2004 Eric Gerbier <gerbier@users.sourceforge.net> 1.8.0
- for new files, display inode date
- for deleted files, display parent change date
- output format change to allow automatic parsing (comments)
- add all perl dependencies in package
- resolv all name to absolute path
- afick-tk, more homogenous gui
- afick-tk, add tree view
- afick-tk, add balloon for context help

* Sat Jan 17 2004 Eric Gerbier <gerbier@hilarion.meteo.fr> 1.7.0
- add a line to explain fields on print action
- add html doc 
- add acl instead uid field on windows (Win32::Filesecurity)
- now use POSIX macros for portability
- afick-tk, add a little 'wizard'
- afick-tk, now display file number and percent
- clean code with more global var and hash
- add sha1 checksum

* Wed Jan 01 2004 Eric Gerbier <gerbier@hilarion.meteo.fr> 1.6.0
- fix a bug on report_url
- detect changes during scan
- fix a bug on deleted directories if not report_full
- add a new -t/timing flag to print cpu statistics
- add a new -r/--running_files to warn about modified files during program run

* Wed Dec 10 2003 Eric Gerbier <gerbier@hilarion.meteo.fr> 1.5.0
- add exclude_suffix directive
- add progress option for afick-tk
- new sub warning
- add new warnings on bad config lines
- fix a bug on alias resolution
- afick-tk, add progress bar and file stat
- afick-tk, add warning section, and update window
- afick-tk, rewrite widget structure
- afick-tk, new warning sub
- afick-tk, change saved output to .log
- afick-tk, rewrite help

* Wed Nov 27 2003 Eric Gerbier <gerbier@hilarion.meteo.fr> 1.4.1
- afick.cron, now test -x (leo west)
- rewrite afick help in a better way
- a better control between afick and afick.pl calls

* Mon Nov 13 2003 Eric Gerbier <gerbier@hilarion.meteo.fr> 1.4.0
- add an auto-control to check afick changes
- afick-tk, version in title
- perl checking for sub arguments
- change getopt for compatibility with old perl version
- allways get a hostname in cron job
- the exit status now depends upon changes

* Mon Oct 14 2003 Eric Gerbier <gerbier@hilarion.meteo.fr> 1.3.0
- add file type
- sort results
- add menu entries
- add report_full_newdel directive
- add ignore_missing_file directive
- add WARNING word for all warning
- add long options (gnu, posix)
- default config file change according operating system
- afick-tk, change cursor to clock during search
- afick-tk, radio-buttons to configure options
- afick-tk, fix bug in save config on windows

* Wed Oct 02 2003 Eric Gerbier <gerbier@hilarion.meteo.fr> 1.2.0
- add report and debug subroutines to have more general use
- add report_url directive (stdout, stderr, null)
- now have summary and detailed output
- test for directories for equal scan
- automatic database init on first install
- fix a bug on -l flag
- remove checksum on sockets
- afick-tk , edit and save config file
- afick-tk , report stderr too
- afick-tk , clear output after each operation
- afick-tk , outpout expand to fill window

* Mon Sep 22 2003 Eric Gerbier <gerbier@hilarion.meteo.fr> 1.1.0
- debian appliance
- new warn_dead_symlinks directive
- bugfix in md5 checksum
- distinguish dir and dir/ for =
- add quit buttons in afick-tk
- add about window in afick-tk
- add manpage for afick-tk
- add log file for cron jobs
- add logrotate for log file
- improved cron job (mailto and lines macros)

* Tue Sep 20 2003 Eric Gerbier <gerbier@hilarion.meteo.fr> 1.0.0
- default config file is /etc/afick.conf
- default database in /var/lib/afick
- default run by cron on a daily base
- database name now in config file (-b option is obsolete now)
- new "equals" file directive in config file ( directories to scan, withour recurse)
- new beta tk interface : afick-tk
- add ctime (c) and block count (b) parameters
- md5 parameter for use instead "h" (obsolete)

* Tue Aug 18 2003 Eric Gerbier <gerbier@hilarion.meteo.fr>
- release 0.9.3 : add aliases
- new config man page

* Tue Aug 12 2003 Eric Gerbier <gerbier@hilarion.meteo.fr>
- release 0.9.2 : add attributes

* Tue Sep 10 2002 Eric Gerbier <gerbier@hilarion.meteo.fr>
- Initial spec file created by autospec ver. 0.6 with rpm 2.5 compatibility
