#!/usr/bin/perl
###############################################################################
#    Copyright (C) 2002-2204 by Eric Gerbier
#    Bug reports to: gerbier@users.sourceforge.net
#    $Id: test_os.sh 872 2006-08-17 09:32:26Z gerbier $
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
###############################################################################
# this script is to be called at begin of install
# it is in perl to allow it to work on windows

use strict;
use warnings;

use Getopt::Long;      # option analysis
use File::Basename;    # dirname
use File::Copy;
use English '-no_match_vars';

## no critic (ProhibitPackageVars)
use vars qw( $Verbose );
## use critic

my $Version = '0.2-0';

#############################################################
# just display program version
sub version($) {
	my $version = shift @_;
	print "\n";
	print
"afick_preinstall : another file integrity checker configurator\nversion $version\n";
	return;
}
#############################################################
# usage
# print some help
sub usage($) {
	my $version = shift @_;
	print <<"EOHELP";

Usage: $PROGRAM_NAME [options]

afick_preinstall options (control afickonfig)  : 
 -c|--config_file file        configname of config file to use
 -h|--help                    show this help page
 -V|--version                 show afickonfig version
 -v|--verbose		     for debugging


Disclaimer:
This script is intended to provide a means for
detecting changes made to files, via a regular
comparison of MD5 hashes to an established baseline. 

Copyright (c) 2006 Eric Gerbier <gerbier\@users.sourceforge.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
EOHELP
	return;
}
#############################################################

# afick library
# we do not call afick library here to be able
# to use before any install (debian pre-inst)
#my $dirname = dirname($0);
#require $dirname . '/afick-common.pl';

$OUTPUT_AUTOFLUSH = 1;

# arg line
my $help;
my $configfile;
my $version;
Getopt::Long::Configure('no_ignore_case');
if (
	!GetOptions(
		'config_file|c=s' => \$configfile,
		'help|h'          => \$help,
		'verbose|v'       => \$Verbose
	)
  )
{
	usage($Version);
	die "abort : incorrect option\n";

}
if ($help) {

	# -h : help
	usage($Version);
	exit;
}
elsif ($version) {

	# -V : version
	version($Version);
	exit;
}

if ( !$configfile ) {

	#$configfile = get_default_config();
	# we should provide a default config file
	# to work on debian installer
	$configfile = '/etc/afick.conf';
}

if ( !-r $configfile ) {
	exit;
}

# first save old config file
copy( $configfile, $configfile . '.sav' );
print "save configuration file to $configfile.sav\n";

# open config file and save all line past the mark to "local" config file
# (prepare work for afick_postinstall)
my $local_config = $configfile . '.local';

# be carefull : this is redefined in afick_postinstall !
my $mark = 'put your local config below';

my $fh_local;
my $fh_config;

## no critic (RequireBriefOpen)
if ( !open $fh_config, '<', $configfile ) {
	die "can not open $configfile : $ERRNO\n";
}
if ( !open $fh_local, '>', $local_config ) {
	die "can not open $local_config : $ERRNO\n";
}

my $local = 0;
while (<$fh_config>) {
	if ($local) {
		print {$fh_local} $_;

		#debug("copy line $_");
	}
	elsif (m/$mark/) {
		$local = 1;
	}
}
close $fh_config or warn "can not close $configfile : $ERRNO\n";
if ( close $fh_local ) {
	print "save local configuration file to $local_config\n";
}
else {
	warn "can not close $local_config : $ERRNO\n";
}
