/***************************************************************************
 *   Copyright (C) 2005 by Felipe Sateler                                  *
 *   fsateler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _AUTOSTART_H_
#define _AUTOSTART_H_

#include <kcmodule.h>

#include <appinfo.h>

class KAboutData;
class KListView;
class KGroupBox;
class QPushButton;
class AutostartWidget;
class KDirLister;
class KFileItem;

/// Defines the autostart module
/**
 * @author Felipe Sateler
 */
class Autostart: public KCModule
{
	Q_OBJECT

public:
	/// Constructor
	/** Constructs an autostart module.
	 */
	Autostart( QWidget *parent=0, const char *name=0, const QStringList& = QStringList() );
	/** Destructor */
	~Autostart();

	/// Load configuration
	/** Reads the autostart directory, and populates 
	 * the widgets with the entries found there.
	 */
	virtual void load();
	/// Save configuration
	/** Writes the appropiate entries in the autostart directory.
	 * Deletes any files found there.
	 */
	virtual void save();
	/** Query which buttons are to be displayed in the kcmshell */
	virtual int buttons();
	/** Give some useful information about the module */
	virtual QString quickHelp() const;
	/// Accesor method
	virtual const KAboutData *aboutData()const
		{ return myAboutData; };

public slots:
	/// The widget has been changed
	/** This gets called when the widget has changed it's status (eg: a new
	 * application has been added)
	 */
	void widgetChanged();
	
protected slots:
	/// Loading of files finished
	/** Gets called when the files have finished loading
	 */
	void loadCompleted();
	/// Loading of files
	/** Gets called when there are files to be read and loaded (at load time)
	 * @param items The files to be read
	 */
	void loadItems(const KFileItemList& items);
	/// Removing of files finished
	/** Gets called when all files in the autostart directory have been deleted
	 */
	void removeCompleted();
	/// Removing of files
	/** Gets called when there are files which need to be deleted (at save time)
	 * @param items The files to be deleted
	 */
	void removeItems(const KFileItemList& items);
	

protected:
	/// Retrieve information about a given file
	/** Reads the given file, and parses necessary information
	 * @param file The file to be parsed
	 * @return The application information
	 */
	AppInfo* parseFile(const KFileItem* file);
	
private:
	KAboutData *myAboutData;
	AutostartWidget* widget;
	
	KDirLister *lister;
	AppInfo::List info;
};

#endif
