/***************************************************************************
 *   Copyright (C) 2005 by Felipe Sateler                                  *
 *   fsateler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <klineedit.h>

#include "autostartappdialog.h"


AutostartAppDialog::AutostartAppDialog(QWidget* parent, const char* name, WFlags fl)
{
	AutostartAppDialog(QString::null, QString::null, QString::null, parent, name, fl);
}

AutostartAppDialog::AutostartAppDialog(const QString& oldName, const QString& oldCommand, const QString& oldComment,
									   QWidget* parent, const char* name, WFlags fl)
	: AutostartAppDialogBase(parent, name, fl)
{
	inputName->setText(oldName);
	inputCommand->setText(oldCommand);
	inputComment->setText(oldComment);
}

AutostartAppDialog::~AutostartAppDialog()
{}

QString AutostartAppDialog::getName() const
{
	return inputName->text();
}

QString AutostartAppDialog::getCommand() const
{
	return inputCommand->text();
}

QString AutostartAppDialog::getComment() const
{
	return inputComment->text();
}

