/***************************************************************************
 *   Copyright (C) 2005 by Felipe Sateler                                  *
 *   fsateler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef AUTOSTARTAPPDIALOG_H
#define AUTOSTARTAPPDIALOG_H

#include "autostartappdialogbase.h"

/// A dialog to add or modify an application
/** Provides an interface to get application information
 * @author Felipe Sateler
 */
class AutostartAppDialog : public AutostartAppDialogBase
{
public:
	/// Constructor 
	/** Constructs a new application dialog. Old information may be passed to be displayed.
	 * To display it, call one of QDialog's provided methods.
	 * @param oldName The previous name the application had, if any. May be null.
	 * @param oldCommand The previous name the application had, if any. May be null.
	 * @param oldComment The previous name the application had, if any. May be null.
	 * @param parent The parent widget.
	 * @param name The widget name
	 * @param fl Widget flags
	 */
	AutostartAppDialog(const QString& oldName, const QString& oldCommand, const QString& oldComment,
					   QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
	/**
	 * @overload AutostartAppDialog::AutostartAppDialog(QWidget *parent=0, const char *name=0, WFlags fl=0)
	 */	
	/// Constructor
	AutostartAppDialog(QWidget* parent = 0, const char* name = 0, WFlags fl = 0);

	/// Destructor
	~AutostartAppDialog();

	/// Accessor method
	/** 
	 * @return The application name the user provided. Do not use if the user hasn't clicked OK!
	 */
	QString getName() const;
	/// Accessor method
	/** 
	 * @return The application command the user provided. Do not use if the user hasn't clicked OK!
	 */
	QString getCommand() const;
	/// Accessor method
	/**
	 * @return The application comment the user provided. Do not use if the user hasn't clicked OK!
	 */
	QString getComment() const;
};

#endif
