/***************************************************************************
 *   Copyright (C) 2005 by Felipe Sateler                                  *
 *   fsateler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/
#include <klocale.h>

#include "autostartlistviewitem.h"
#include "appinfo.h"

AutostartListViewItem::AutostartListViewItem(QListView* parent)
	: KListViewItem(parent), info(0)
{}


AutostartListViewItem::~AutostartListViewItem()
{
	delete info;
}

AppInfo* AutostartListViewItem::getInfo() const
{
	return info;
}

void AutostartListViewItem::setInfo(AppInfo* newInfo)
{
	
	if( newInfo != info )
	{
		delete info;
		info = newInfo;
	}
	setText( TYPE, info->getStrType() );
	setText( NAME, info->getName() );

	QString extra;
	switch(info->getType())
	{
	case AppInfo::DESKTOP:
		extra = i18n("Command: ") + dynamic_cast<DesktopAppInfo*>(info)->getCommand() +
		        i18n("\tComment: ") + dynamic_cast<DesktopAppInfo*>(info)->getComment();
		break;
	case AppInfo::LINK:
		extra = i18n("Link to: ")+dynamic_cast<LinkAppInfo*>(info)->getDestination();
		break;
	case AppInfo::SCRIPT:
		extra = i18n("Script language: ")+dynamic_cast<ScriptAppInfo*>(info)->getLang();
		break;
	}
	setText(EXTRAINFO, extra);
}
