/***************************************************************************
 *   Copyright (C) 2005 by Felipe Sateler                                  *
 *   fsateler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef AUTOSTARTLISTVIEWITEM_H
#define AUTOSTARTLISTVIEWITEM_H

#include <klistview.h>

class AppInfo;

/// A specialized list view item
/** Items displayed in the autostart module list view are of this type.
 * @author Felipe Sateler
*/
class AutostartListViewItem : public KListViewItem
{
public:
	/// Constructor
	/** Constructs a new item to be displayed inside a list view
	 * @param parent The list view where the item should be displayed
	 */
    AutostartListViewItem(QListView* parent);

	///Destructor
    ~AutostartListViewItem();
	
	/// Accessor
	/** Sets the information of the item
	 * @param info The information to display.
	 */
	void setInfo(AppInfo* info);
	/// Accessor
	/** Gets the information of the item
	 * @return The application information
	 */
	AppInfo* getInfo() const;

private:
	AppInfo* info;
	
	enum TEXTPOS
	{
		TYPE = 0,
		NAME = 1,
		EXTRAINFO = 2
	};
};

#endif
