/***************************************************************************
 *   Copyright (C) 2005 by Felipe Sateler                                  *
 *   fsateler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <qgroupbox.h>
#include <klistview.h>
#include <kpushbutton.h>
#include <klocale.h>
#include <kinputdialog.h>
#include <qvaluelist.h>
#include <klineedit.h> 
#include <krun.h>

#include "autostartwidget.h"
#include "autostartlistviewitem.h"
#include "autostartdesktopappdialog.h"
#include "appinfo.h"

AutostartWidget::AutostartWidget(QWidget* parent, const char* name, WFlags fl)
		: AutostartWidgetBase(parent,name,fl)
{
	groupBox->setTitle( i18n("User startup apps") );
	appListView->addColumn( i18n("Application Type") );
	appListView->addColumn( i18n("Name") );
	appListView->addColumn( i18n("Extra information") );
}

AutostartWidget::~AutostartWidget()
{}

void AutostartWidget::slotEdit()
{
	AutostartListViewItem* item = dynamic_cast<AutostartListViewItem*>( appListView->currentItem() );
	if( item == NULL )
		return;
	AppInfo* info = item->getInfo();

	AppInfo* newInfo = NULL;
	switch( info->getType() )
	{
	case AppInfo::DESKTOP:
	{
		AutostartDesktopAppDialog dlg(this);
		DesktopAppInfo* desktopInfo = dynamic_cast<DesktopAppInfo*>(info);
		dlg.inputName->setText(desktopInfo->getName());
		dlg.inputCommand->setText(desktopInfo->getCommand());
		dlg.inputComment->setText(desktopInfo->getComment());
		
		// User closed with OK
		if( dlg.exec() == QDialog::Accepted)
		{
			QString name = dlg.inputName->text();
			QString command = dlg.inputCommand->text();
			QString comment = dlg.inputComment->text();
			newInfo = new DesktopAppInfo( name, command, comment );
		}
		break;
	}
	case AppInfo::LINK:
	{
		bool ok;
		QString name = KInputDialog::getText(i18n("Name"), i18n("Insert the application's name"),
											 info->getName(), &ok );
		if( !ok )
			break;
		QString destination = KInputDialog::getText(i18n("Destination"), i18n("Where to point the link?"), 
				dynamic_cast<LinkAppInfo*>(info)->getDestination(), &ok );
		if( !ok )
			break;
		newInfo = new LinkAppInfo( name, destination );
		break;
	}
	case AppInfo::SCRIPT:
	{
		bool ok;
		QString name = KInputDialog::getText(i18n("Name"), i18n("Insert the application's name"),
											 info->getName(), &ok );
		if( !ok )
			break;
		QString code = KInputDialog::getMultiLineText(i18n("Insert script's code"), i18n("Code:"),
				dynamic_cast<ScriptAppInfo*>(info)->getCode(), &ok );
		if( !ok )
			break;
		newInfo = new ScriptAppInfo( name, code );
		break;
	}
	case AppInfo::UNKNOWN:
		KRun* run = new KRun( KGlobalSettings::autostartPath()+info->getName(), this );
		break;
	
	}
	
	if( newInfo != NULL )
	{
		item->setInfo( newInfo );
		emit changed();
	}
}

void AutostartWidget::slotRemove()
{
	appListView->removeItem( appListView->currentItem() );

	emit changed();
}

void AutostartWidget::slotAdd()
{
	AutostartDesktopAppDialog dlg(this);

	// User closed with OK
	if( dlg.exec() == QDialog::Accepted )
	{
		QString name = dlg.inputName->text();
		QString command = dlg.inputCommand->text();
		QString comment = dlg.inputComment->text();

		AutostartListViewItem *item = new AutostartListViewItem(appListView);
		AppInfo* newInfo = new DesktopAppInfo(name, command, comment);
		item->setInfo(newInfo);

		emit changed();
	}
}

void AutostartWidget::load(AppInfo::List& list)
{
	appListView->clear();
	QPtrListIterator<AppInfo> it(list);
	AppInfo* curr;

	while( (curr = it.current() ) != NULL )
	{
		AutostartListViewItem *item = new AutostartListViewItem(appListView);
		item->setInfo(curr);
		++it;
	}
}

AppInfo::List AutostartWidget::save() const
{
	AutostartListViewItem* item = dynamic_cast<AutostartListViewItem*>( appListView->firstChild() );
	AppInfo::List list;
	while( item != NULL )
	{
		AppInfo* info = item->getInfo();
		list.append(info);

		item = dynamic_cast<AutostartListViewItem*>( item->nextSibling() );
	}
	return list;
}


#include "autostartwidget.moc"

