/***************************************************************************
 *   Copyright (C) 2005 by Felipe Sateler                                  *
 *   fsateler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef AUTOSTARTWIDGET_H
#define AUTOSTARTWIDGET_H

#include "autostartwidgetbase.h"

#include "appinfo.h"

/// The widget in which the applications are displayed 
/**
 * Displays the applications in a list view
 */
class AutostartWidget : public AutostartWidgetBase
{
	Q_OBJECT

public:
	/// Constructor
	AutostartWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	/// Destructor
	~AutostartWidget();
	/*$PUBLIC_FUNCTIONS$*/
	/// Load application information 
	/** Loads the provided information into the widget. Previous information is lost 
	 * @param info The application information to load
	 */
	void load(AppInfo::List& info);
	/// Save application information 
	/** Gets the information contained in the list view.
	 * @return The application information
	 */
	AppInfo::List save() const;

public slots:
	/*$PUBLIC_SLOTS$*/
	/// 'Edit' button slot
	virtual void          slotEdit();
	/// 'Remove' button slot
	virtual void          slotRemove();
	/// 'Add' button slot
	virtual void          slotAdd();

signals:
	/// Information modified signal
	/** Emitted when the user modified anything */
	void changed();
protected:
	/*$PROTECTED_FUNCTIONS$*/

protected slots:
	/*$PROTECTED_SLOTS$*/

};

#endif

