/*
   freedup -- search for duplicate files in one or more directory hierarchies
   Copyright (C) 2007,2008 AN@freedup.org.
*/
/* freedup was written by AN <AN@freedup.org>  */
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include "auto.h"

const int    mp3test(const unsigned char*buffer)
{
    /* Range used: 0-2 */
    /* Tag Header */
    if( buffer[0]=='I' && buffer[1]=='D' && buffer[2]=='3') return 1;
    /* MP2/MP3 Header */
    if( buffer[0]==(unsigned char)'\377' && (buffer[1]&'\350')==(unsigned char)'\350')    return 1;
    /* failed */
    return 0;
}

const int    mp3fulltest(const char*a)
{
    size_t count;
    unsigned char buffer[32];
    FILE*A=fopen(a,"rb");
    if(A==NULL) return 0;
    count=fread(buffer,sizeof(char),4,A);
    fclose(A);
    if(count<4) return 0;
    return mp3test(buffer);
}

const size_t mp3start(const char*a)
{
    int count=0,version;
    unsigned char buffer[10];
    FILE*A=fopen(a,"rb");
    if(A==NULL) return 0;
    count=fread(buffer,sizeof(char),10,A);
    fclose(A);
    tag2char='2';
    if( buffer[0]=='I' && buffer[1]=='D' && buffer[2]=='3')
    {
        version= buffer[3];
	count += buffer[6] << 21;
	count += buffer[7] << 14; 
	count += buffer[8] << 7; 
	count += buffer[9]; 
	return count;
    }
    return 0;
}

const size_t mp3end(const char*a)
{
    int n;
    unsigned char buffer[256];
    FILE*A=fopen(a,"rb");
    if(A==NULL) return 0;
    fseek(A, -128, SEEK_END);
    n=fread(buffer,sizeof(char),256,A);
    fclose(A);
    tag1char='1';
    if(n!=128) return 0;
    if( buffer[0] == 'T' && buffer[1] == 'A' && buffer[2] == 'G')
    {   return  128;
    } else return 0;
}

const size_t mp3size(const char*a)
{
    static struct stat xstat;
    if( stat( a, &xstat) == 0 )
    {
	return (xstat.st_size-mp3start(a)-mp3end(a));
    } else
    return 0;
}

#if defined(MP3_TEST)
#include <assert.h>
int main(int a, char*v[])
{
    int n,cnt,end;
    char buffer[204800];
    FILE*A;
    if(a<2) { fprintf(stderr,"File Argument missing.\n"); exit(-1); }
    if(mp3fulltest(v[1])!=1) { fprintf(stderr,"File Argument not of type mp3.\n"); exit(-1); }
    cnt=mp3start(v[1]);
    end=mp3end(v[1]);
    if(a>1) fprintf(stderr,"%s: [ %d ] %d %d \n",v[1],mp3size(v[1]),cnt,end);
    A=fopen(v[1],"rb");
    assert(A!=NULL);
    fseek(A, cnt, SEEK_SET);
    n=fread(buffer,sizeof(char),81920,A);
    fclose(A);
    A=fopen("/tmp/test.mp3","wb");
    assert((A!=NULL));
    fwrite(buffer,sizeof(char),81920,A);
    fclose(A);
    system("file /tmp/test.mp3");
    return 0;
}
#endif
