/*
   freedup -- search for duplicate files in one or more directory hierarchies
   Copyright (C) 2007,2008 AN@freedup.org.
*/
/* freedup was written by AN <AN@freedup.org>  */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include "auto.h"

const int    mp4test(const unsigned char*buffer)
{
    /* Range used: 4-8 */
    /* MP4 Header */
    if( buffer[4]=='f' && buffer[5]=='t' && buffer[6]=='y' && buffer[7]=='p') return 1;
    if( buffer[4]=='m' && buffer[5]=='o' && buffer[6]=='o' && buffer[7]=='v') return 1;
    /* failed */
    return 0;
}

const int    mp4fulltest(const char*a)
{
    size_t count;
    unsigned char buffer[32];
    FILE*A = fopen(a,"rb");
    if(A==NULL) return 0;
    count = fread(buffer,sizeof(char),32,A);
    fclose(A);
    return mp4test(buffer);
}

const size_t mp4start(const char*a)
{
    int size=8,retval,count=0;
    unsigned char buffer[32];
    FILE*A=NULL;
    if( (A=fopen(a,"rb"))==NULL ) return 0;
    retval = fread( buffer, sizeof(char), size, A );
    tag1char='S';
    if( (retval<size) || !mp4test(buffer) ) return 0;
    while( !strncmp( (char*)&buffer[4], "ftyp", 4 )
	|| !strncmp( (char*)&buffer[4], "moov", 4 )
	|| !strncmp( (char*)&buffer[4], "free", 4 )
	|| !strncmp( (char*)&buffer[4], "wide", 4 )
	|| !strncmp( (char*)&buffer[4], "meta", 4 ) )
	/* "mdat" contains the encoded song */
    {
if(0) fprintf(stderr,"%s> %d %d\n",a,size,retval);
	size = (buffer[0] << 24) + (buffer[1] << 16) + (buffer[2] << 8) + buffer[3]; 
	if( fseek( A, size-8, SEEK_CUR ) || (size<=8) ) return 0;
	count+=size;
    	retval=fread(buffer,sizeof(char),8,A);
   	if( retval < 8 ) return 0; /* header might end at eof */
    }
    fclose(A);
    return count;
}

const size_t mp4end(const char*a)
{
    static struct stat xstat;
    int size=8,retval=0;
    unsigned char buffer[24];
    FILE*A=NULL;
    buffer[8]=0;
    if( stat( a, &xstat) != 0 ) return 0;
    if( (A=fopen(a,"rb"))==NULL ) return 0;
    tag2char='F';
    retval = fread( buffer, sizeof(char), size, A );
    if( (retval<size) || !mp4test(buffer) ) return 0;
    while(!feof(A))
    {
	size = (buffer[0] << 24) + (buffer[1] << 16) + (buffer[2] << 8) + buffer[3]; 
#if defined(MP4_TEST)
	{   /* debugging */
	    static char text[8];
            strncpy( text, (char*)&buffer[4], 4 );
	    text[4]=0;
	    fprintf(stderr,"%s:%8d\n",text,size);
	}
#endif
	if( strncmp((char*)&buffer[4],"mdat",4)==0 )
	{
	    retval=((int)ftell(A))+size-8;
	}
	if( fseek( A, size-8, SEEK_CUR ) || (size<=8) )
	{
	    fclose(A);
	    return 0;
	}
        if( fread(buffer,sizeof(char),8,A)<8 )
	{
	    fclose(A);
	    return ((int)xstat.st_size)-retval;
	}
    }
    fclose(A);
    return (((int)xstat.st_size)-retval);
}

const size_t mp4size(const char*a)
{
    static struct stat xstat;
    if( stat( a, &xstat) == 0 )
    {
	return (xstat.st_size-mp4start(a)-mp4end(a));
    } else
    return 0;
}

#if defined(MP4_TEST)
#include <assert.h>
int main(int a, char*v[])
{
    int n,cnt,end;
    char buffer[204800];
    FILE*A;
    if(a<2) { fprintf(stderr,"File Argument missing.\n"); exit(-1); }
    if(mp4fulltest(v[1])!=1) { fprintf(stderr,"File Argument not of type mp4.\n"); exit(-1); }
    cnt=mp4start(v[1]);
    end=mp4end(v[1]);
    if(a>1) fprintf(stderr,"%s: [ %d ] %d %d \n",v[1],mp4size(v[1]),cnt,end);
    A=fopen(v[1],"rb");
    assert(A!=NULL);
    fseek(A, cnt, SEEK_SET);
    n=fread(buffer,sizeof(char),81920,A);
    fclose(A);
    A=fopen("/tmp/test.mp4","wb");
    assert((A!=NULL));
    fwrite(buffer,sizeof(char),81920,A);
    fclose(A);
    system("file /tmp/test.mp4");
    return 0;
}
#endif
