/*
   freedup -- search for duplicate files in one or more directory hierarchies
   Copyright (C) 2007,2008 AN@freedup.org.
*/

/* freedup was written by AN <AN@freedup.org>  */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include "auto.h"

const int    mpctest(const unsigned char*buffer)
{
    /* Range used: 0-8 */
    /* MousePack Header */
    if( buffer[0]=='M' && buffer[1]=='P' && buffer[2]=='+') return 1;
    /* failed */
    return 0;
}

const int    mpcfulltest(const char*a)
{
    size_t count;
    unsigned char buffer[32];
    FILE*A = fopen(a,"rb");
    if(A==NULL) return 0;
    count = fread(buffer,sizeof(char),32,A);
    fclose(A);
    return mpctest(buffer);
}

const size_t mpcstart(const char*a)
{
    /* no mouse pack format with initial header known */
    tag2char=' ';
    return 0;
}

const size_t mpcend(const char*a)
{
    int n;
    unsigned char buffer[256];
    FILE*A=fopen(a,"rb");
    if(A==NULL) return 0;
    tag1char='A';
    /* try APETAGEX footer */
    fseek(A, -32, SEEK_END);
    n = fread( buffer, sizeof(char), 32, A );
    if(n!=32) return 0;
    if( strncmp((const char*)buffer, "APETAGEX", 8) == 0 )
    {   return  32+(buffer[12]+(buffer[13]<<8)+(buffer[14]<<16)+(buffer[15]<<24));
    } else return 0;
}

const size_t mpcsize(const char*a)
{
    static struct stat xstat;
    if( stat( a, &xstat) == 0 )
    {
	return (xstat.st_size-mpcstart(a)-mpcend(a));
    } else
    return 0;
}

#if defined(MPC_TEST)
#include <assert.h>
int main(int a, char*v[])
{
    int n,cnt,end;
    char buffer[204800];
    FILE*A;
    if(a<2) { fprintf(stderr,"File Argument missing.\n"); exit(-1); }
    if(mpcfulltest(v[1])!=1) { fprintf(stderr,"File Argument not of type mpc.\n"); exit(-1); }
    cnt=mpcstart(v[1]);
    end=mpcend(v[1]);
    if(a>1) fprintf(stderr,"%s: [ %d ] %d %d \n",v[1],mpcsize(v[1]),cnt,end);
    A=fopen(v[1],"rb");
    assert(A!=NULL);
    fseek(A, cnt, SEEK_SET);
    n=fread(buffer,sizeof(char),81920,A);
    fclose(A);
    A=fopen("/tmp/test.mpc","wb");
    assert((A!=NULL));
    fwrite(buffer,sizeof(char),81920,A);
    fclose(A);
    system("file /tmp/test.mpc");
    return 0;
}
#endif
