/*
   freedup -- search for duplicate files in one or more directory hierarchies
   Copyright (C) 2007,2008 AN@freedup.org.
*/

/* freedup was written by AN <AN@freedup.org>  */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <assert.h>
#include "auto.h"
#define	OGGTAILSIZE	1024
#define	OGGHEADSIZE	8192
/*
 * Information sources:
 *	http://en.wikipedia.org/wiki/Ogg
 * 	http://en.wikipedia.org/wiki/Comparison_of_container_formats
 */

const int    oggtest(const unsigned char*buffer)
{
    /* Range used: 0-3 */
    if( buffer[0]=='O' && buffer[1]=='g' && buffer[2]=='g' && buffer[3]=='S') return 1;
    return 0;
}

const int    oggfulltest(const char*a)
{
    size_t count;
    unsigned char buffer[32];
    FILE*A=fopen(a,"rb");
    assert(A!=NULL);
    count=fread(buffer,sizeof(char),10,A);
    fclose(A);
    return oggtest(buffer);
}

const size_t oggstart(const char*a)
{
    int n,count,read=40;
    char buffer[OGGHEADSIZE];
    FILE*A;
    A=fopen(a,"rb");
    if( (count=fread(buffer,sizeof(char),read,A)) < read ) return(0);
    tag1char='H';
    if( buffer[0]=='O' && buffer[1]=='g' && buffer[2]=='g' && buffer[3]=='S')
    {
        count+=fread(buffer,sizeof(char),OGGHEADSIZE,A);
	fclose(A);
        do 
	    for(n=0; n<OGGHEADSIZE && !(buffer[n]=='\001' && buffer[n+1]=='\005');n++);
        while( !strncmp(&buffer[n+2],"vorbis",6) && strncmp(&buffer[n+9],"BCV",3) );
	return(n+40);
    }
    return 0;
}

const size_t oggend(const char*a)
{
    int rdsize=0;
    char buffer[OGGTAILSIZE],*ptr=NULL;
    FILE*A=NULL;
    A=fopen(a,"rb");
    if( A==NULL ) return(0);
    if( fseek(A, -OGGTAILSIZE, SEEK_END) != 0) return 0;
    tag1char='T';
    rdsize=fread(buffer,sizeof(char),OGGTAILSIZE,A);
    fclose(A);
    ptr=buffer;
    while( (ptr=strchr(ptr,'O')) != NULL )
    {
	if( strncmp(ptr,"OggS",4) ) return(rdsize-(int)(ptr-buffer));
    }
    return 0;
}

const size_t oggsize(const char*a)
{
    static struct stat xstat;
    if( stat( a, &xstat) == 0 )
    {
	return (xstat.st_size-oggstart(a)-oggend(a));
    } else
    return 0;
}

#if defined(OGG_TEST)

int main(int a, char*v[])
{
    int n,cnt,end;
    char buffer[8200000];
    FILE*A,*B;
    cnt=oggstart(v[1]);
    end=oggend(v[1]);
    if(oggfulltest(v[1])!=1) { fprintf(stderr,"File Argument not of type ogg.\n"); exit(-1); }
    if(a>1) fprintf(stderr,"%s: %d %d\n",v[1],cnt,end);
    A=fopen(v[1],"rb");
    B=fopen("/tmp/test.ogg","wb");
    n=fread(buffer,sizeof(char),cnt,A);
    n=fread(buffer,sizeof(char),8192000,A);
    fwrite(buffer,sizeof(char),n,B);
    fclose(A);
    fclose(B);
    system("mpg321 /tmp/test.ogg");
    return 0;
}
#endif
