#!/bin/bash
#
# Copyright 2007 Google Inc. All Rights Reserved.
export LANG=en_US.UTF-8
export LC_ALL=en_US.UTF-8
if [ $# -ne 1 -o ! -f "$1" ]; then
  exit 1
fi

tmpdir=${TMPDIR:-/tmp}

WVTEXT=`which wvText`
WVWARE=`which wvWare`
CATDOC=`which catdoc`
XLS2CSV=`which xls2csv`
CATPPT=`which catppt`

FILENAME="$1"
EXT="${FILENAME##*.}"

rm -f $tmpdir/gdlinux-mso-* &> /dev/null

if [ "$EXT" = "doc" -o "$EXT" = "DOC" ]; then
  if [ -x "$WVTEXT" ]; then
    # Copy the file before running wvWare, because
    # wvWare will open the file with read/write mode.
    TMPNAME=`mktemp "$tmpdir/gdlinux-mso-XXXXXXXX"`
    cp "$FILENAME" "$TMPNAME"
    "$WVTEXT" "$TMPNAME" "$TMPNAME.txt" &> /dev/null
    cat "$TMPNAME.txt"
    if [ "$?" -ne "0" -a -x "$WVWARE" ]; then
      "$WVWARE" -x wvText.xml "$TMPNAME"
      cat "$TMPNAME.txt"
    fi
    rm -f ${TMPNAME}*
  elif [ -x "$CATDOC" ]; then
    "$CATDOC" "$FILENAME"
  fi
elif [ "$EXT" = "xls" -o "$EXT" = "XLS" ]; then
  if [ -x "$XLS2CSV" ]; then
    "$XLS2CSV" "$FILENAME"
  fi
elif [ "$EXT" = "ppt" -o "$EXT" = "PPT" -o "$EXT" = "pps" -o "$EXT" = "PPS" ]; then
  if [ -x "$CATPPT" ]; then
    "$CATPPT" "$FILENAME"
  fi
fi
