/***************************************************************************
 *   Copyright (C) 2006 by Dmitry Morozhnikov   *
 *   dmiceman@mail.ru   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../config.h"

#include <kapplication.h>
#include <klocale.h>
#include <kmainwindow.h>
#include <kpushbutton.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <kurlrequester.h>
#include <kurlrequesterdlg.h>
#include <kglobal.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <krecentdocument.h>
#include <klineedit.h>
#include <krun.h>
#include <kcmdlineargs.h>
#include <dcopclient.h>
#include <kiconloader.h>

#include "kfuseisomount.h"

#include "fuseisolib.h"

// heavily based on KURLRequesterDlg
// why the hell everything in kde classes declared private!?

void FuseisoMountDlg::initDialog(const QString &text,const QString &urlName)
{
    disableResize();
    
    QVBoxLayout * topLayout = new QVBoxLayout( plainPage(), 0,
        spacingHint() );

    QLabel * label = new QLabel( text , plainPage() );
    topLayout->addWidget( label );
    
    urlRequester_ = new KURLRequester( urlName, plainPage(), "urlRequester" );
    urlRequester_->setMinimumWidth( urlRequester_->sizeHint().width() * 3 );
    topLayout->addWidget( urlRequester_ );
    urlRequester_->setFocus();
    connect( urlRequester_->lineEdit(), SIGNAL(textChanged(const QString&)),
        SLOT(slotTextChanged(const QString&)) );
    openBrowser = new QCheckBox(i18n("Open mounted image in new window"), plainPage(), "open_browser");
    topLayout->addWidget(openBrowser);
    bool state = !urlName.isEmpty();
    enableButtonOK( state );
    enableButton( KDialogBase::User1, state );
    connect( this, SIGNAL( user1Clicked() ), SLOT( slotClear() ) );
}

void FuseisoMountDlg::slotTextChanged(const QString & text)
{
    bool state = !text.stripWhiteSpace().isEmpty();
    enableButtonOK( state );
    enableButton( KDialogBase::User1, state );
}

void FuseisoMountDlg::slotClear()
{
    urlRequester_->clear();
}

KURL FuseisoMountDlg::selectedURL() const
{
    if ( result() == QDialog::Accepted )
        return KURL::fromPathOrURL( urlRequester_->url() );
    else
        return KURL();
}

int main( int argc, char **argv )
{
    KCmdLineArgs::init(argc, argv, "kfuseisomount", 
        PACKAGE, i18n("Utility to mount disk image"),
        VERSION);
    KApplication::addCmdLineOptions();
    KApplication app;
    app.dcopClient()->attach();
    
    KSimpleConfig config("kfuseisomount");
    
    KFileDialog::setStartDir("::x-iso-image");
    FuseisoMountDlg* dlg = new FuseisoMountDlg("", 
        i18n("Disk image filename"), NULL, "req", true);
    dlg->setIcon(app.iconLoader()->loadIcon("cdtrack", KIcon::NoGroup));
    dlg->setCaption(i18n("Mount disk image"));
    KFileDialog* fdlg = dlg->fileDialog();
    KURLRequester* req = dlg->urlRequester();
    QCheckBox* obb = dlg->openBrowserBox();
    obb->setChecked(config.readBoolEntry("openBrowser", true));
    req->setShowLocalProtocol(false);
    fdlg->setPreviewWidget((const KPreviewWidgetBase*) NULL); 
    fdlg->setMode(KFile::File | KFile::ExistingOnly | KFile::LocalOnly);
    req->setMode(KFile::File | KFile::ExistingOnly | KFile::LocalOnly);
    req->setFilter("*.iso *.ISO *.bin *.BIN *.nrg *.NRG *.img *.IMG *.mdf *.MDF|" + i18n("All supported files") + 
        "\n*|" + i18n("All files"));
    dlg->exec();
    KURL url = dlg->selectedURL();
    
    if(url.isValid() && url.isLocalFile()) {
        KURL mount_point;
        FuseisoLib flib;
        QString errstr;
        if(flib.isMounted(url, mount_point) && obb->isChecked()) {
            KRun::runURL(mount_point, "inode/directory");
            
        } else {
            if(flib.mount(url, mount_point, errstr)) {
                if(obb->isChecked()) {
                    KRun::runURL(mount_point, "inode/directory");
                };
            } else {
                KMessageBox::error(0, 
                    QString(i18n("Error while mounting image:\n%1")).arg(errstr));
            };
        };
    };
    
    config.writeEntry("openBrowser", obb->isChecked());
    config.sync();
 
    return 0;
};

#include "kfuseisomount.moc"
