/***************************************************************************
 *   Copyright (C) 2006 by Dmitry Morozhnikov   *
 *   dmiceman@mail.ru   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#pragma once

#include <kurlrequester.h>
#include <kfiledialog.h>
#include <qcheckbox.h>

// heavily based on KURLRequesterDlg
// why the hell everything in kde classes declared private!?

class FuseisoMountDlg : public KDialogBase
{
    Q_OBJECT
    
    public:
        FuseisoMountDlg( const QString& url, const QString& text,
            QWidget *parent, const char *name, bool modal=true ) : 
            KDialogBase( Plain, QString::null, Ok|Cancel|User1, Ok, parent, name,
                    modal, true, KStdGuiItem::clear() ) { initDialog(text, url); };
        
        ~FuseisoMountDlg() {};
    
        KURL selectedURL() const;
    
        KFileDialog * fileDialog() { return urlRequester_->fileDialog(); };
        KURLRequester *urlRequester() { return urlRequester_; };
        QCheckBox *openBrowserBox() { return openBrowser; };
    
    private slots:
        void slotClear();
        void slotTextChanged(const QString &);
    private:
        void initDialog(const QString &text, const QString &url);
        KURLRequester *urlRequester_;
        QCheckBox *openBrowser;
};
