#
# Klogwatch, Netfilter log monitor
#
# Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#

# $1 = library
# $2 = search path
# Updates the LIB variable, if found

AC_DEFUN([XX_FIND_LIB],[
    AC_MSG_CHECKING([$1 library])

    libdir=""
    lib=lib$1.so

    for d in $2
    do
	if test -r $d/$lib
	then
	    echo "configure: __oline__: $1 = $d/$lib" >&5
	    libdir=$d
	    break;
	fi
    done

    if test ${libdir}set = set
    then
	AC_MSG_ERROR([no $1 library found])
    else
	LIBS="-l$1 $LIBS"
	AC_MSG_RESULT([$libdir/$lib])
    fi
])

# $1 = variable to set (KDELIB etc)
# $2 = paths to search
# $3 = file to check for under path

AC_DEFUN([XX_FIND_PATH],
[
    AC_MSG_CHECKING([$1])

    dir=""

    for d in $2
    do
	if test -r $d/$3
	then
	    echo "configure: __oline__: $1 = $d/$3" >&5
	    dir=$d
	    break;
	fi
    done

    if test ${dir}set = set
    then
	AC_MSG_ERROR([can't locate $1])
    else
	$1=$dir
	AC_MSG_RESULT([$dir])
    fi
])


AC_DEFUN([XX_DEFS],
[
x11libs="\
    $with_x11lib \
    $X11DIR/lib \
    /usr/X11/lib \
    /usr/X11R6/lib \
    /usr/X11R5/lib \
    /usr/X11R4/lib \
    /usr/lib/X11 \
    /usr/lib/X11R6 \
    /usr/lib/X11R5 \
    /usr/lib/X11R4 \
    /usr/local/X11/lib \
    /usr/local/X11R6/lib \
    /usr/local/X11R5/lib \
    /usr/local/X11R4/lib \
    /usr/local/lib/X11 \
    /usr/local/lib/X11R6 \
    /usr/local/lib/X11R5 \
    /usr/local/lib/X11R4 \
    /usr/X386/lib \
    /usr/x386/lib \
    /usr/XFree86/lib/X11 \
    /usr/lib \
    /usr/local/lib \
    /usr/unsupported/lib \
    /usr/athena/lib \
    /usr/local/x11r5/lib \
    /usr/lpp/Xamples/lib \
    /lib/usr/lib/X11 \
    /usr/openwin/lib \
    /usr/openwin/share/lib"

kdelibs="\
    $with_kdelib \
    $KDEDIR/lib \
    /usr/lib/kde \
    /usr/local/kde/lib \
    /usr/kde/lib \
    /usr/lib/kde \
    /usr/lib/kde3 \
    /usr/lib \
    /usr/X11R6/lib \
    /usr/local/lib \
    /opt/kde3/lib \
    /opt/kde/lib \
    /usr/X11R6/kde/lib"

kdeincs="\
    $with_kdeinc \
    $KDEDIR/include \
    /usr/local/kde/include \
    /usr/local/include \
    /usr/kde/include \
    /usr/include/kde \
    /usr/include \
    /opt/kde3/include \
    /opt/kde/include \
    /usr/X11R6/include \
    /usr/X11R6/kde/include"

qtlibs="\
    $with_qtlib \
    $QTDIR/lib \
    /usr/lib/qt3/lib \
    /usr/lib/qt/lib \
    /usr/share/qt3/lib"

qtincs="\
    $with_qtinc \
    $QTDIR/include \
    /usr/lib/qt3/include \
    /usr/lib/qt/include \
    /usr/share/qt3/include"

qtbins="\
    $with_qtbin \
    $QTDIR/bin \
    /usr/lib/qt3/bin \
    /usr/lib/qt/bin \
    /usr/bin \
    /usr/share/qt3/bin"
])

AC_SUBST(x11libs)
AC_SUBST(kdelibs)
AC_SUBST(kdeincs)
AC_SUBST(qtlibs)
AC_SUBST(qtincs)
AC_SUBST(qtbins)

# eof
