/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#include "debug.h"
#include "klogICMP.h"

KLogICMP::KLogICMP(const KLogLine *line): KLogIP(line)
{
    debug("Constructing ICMP\n");

    type = line->getInt("TYPE");
    code = line->getInt("CODE");
}

KLogICMP::~KLogICMP()
{
    debug("Destroy ICMP\n");
}

QString KLogICMP::toString(bool full) const
{
    return KLogIP::toString(full) + ": " + getDstPort();
}


QString KLogICMP::getDstPort(void) const
{
    static const char * const typecode[] =
    {
        "echo-reply(0)",
        "1",
        "2",
        "destination-unreachable(3)",
        "source-quench(4)",
        "redirect(5)",
        "6",
        "7",
        "echo-request(8)",
        "9",
        "10",
        "time-exceeded(11)",
        "parameter-problem(12)",
        "timestamp-request(13)",
        "timestamp-reply(14)",
        "info-request(15)",
        "info-reply(16)",
        "address-mask-request(17)",
        "address-mask-reply(18)"
    };

    char b[64];

    if (type >=0 && type <=18)
        sprintf(b, "%s, code %d", typecode[type], code);
    else
        sprintf(b, "Type unknown (%d), code %d", type, code);

    return QString(b);
}

QString KLogICMP::getSrcPort(void) const
{
    return getDstPort();
}

int KLogICMP::getDstPortNum(void) const
{
    if (type >= 0 && type <= 18)
        return (type - 19);
    else
        return (-20);
}

int KLogICMP::getSrcPortNum(void) const
{
    return getDstPortNum();
}

// eof
