/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef KLOGICMP_H
#define KLOGICMP_H

#include "klogIP.h"

class KLogICMP : public KLogIP
{
public:
    KLogICMP(const KLogLine *line);
    virtual ~KLogICMP();

    virtual QString toString(bool) const;
    virtual QString getDstPort(void) const;
    virtual QString getSrcPort(void) const;
    virtual int getDstPortNum(void) const;
    virtual int getSrcPortNum(void) const;

private:
    int     type;
    int     code;
};

#endif
