/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef KLOGIP_H
#define KLOGIP_H

#include <qstring.h>
#include <qdatetime.h>

#include "klogline.h"

class KLogLine;

class KLogIP
{
public:
    KLogIP(const KLogLine *);
    virtual ~KLogIP();

    QString getHost(void) const;
    QString getDate(void) const;
    QString getTime(void) const;
    QString getDateTime(void) const;
    QString getPrefix(void) const;
    QString getSrcIP(void) const;
    virtual QString getSrcPort(void) const;
    virtual int getSrcPortNum(void) const;    
    QString getDstIP(void) const;
    virtual QString getDstPort(void) const;
    virtual int getDstPortNum(void) const;
    QString getProto(void) const;
    QString getInIface(void) const;
    QString getOutIface(void) const;
    QString getMacAddr(void) const;
    virtual QString getFlags(void) const;

    virtual QString toString(bool) const;
    const char *getLine(void) const;

private:
    const   KLogLine *logline;
    QString protocol;
    QDate   date;
    QTime   time;
    QString logPrefix;
    QString datetime;
    QString srcIP;
    QString dstIP;
    QString inIface;
    QString outIface;
    QString macAddr;
};

#endif
