/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef KLOGTCP_H
#define KLOGTCP_H

#include "klogIP.h"

class KLogTCP : public KLogIP
{
public:
    KLogTCP(const KLogLine *line);
    virtual ~KLogTCP();

    virtual QString getSrcPort(void) const;
    virtual QString getDstPort(void) const;
    virtual int getSrcPortNum(void) const;
    virtual int getDstPortNum(void) const;
    virtual QString getFlags(void) const;

    virtual QString toString(bool) const;

private:
    int     srcPort;
    int     dstPort;

    bool    URG;
    bool    ACK;
    bool    PSH;
    bool    RST;
    bool    SYN;
    bool    FIN;
};

#endif
