/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#include <netdb.h>
#include <netinet/in.h>

#include "debug.h"
#include "klogUDP.h"

KLogUDP::KLogUDP(const KLogLine *line) : KLogIP(line)
{
    debug("Constructing UDP\n");

    srcPort = line->getInt("SPT");
    dstPort = line->getInt("DPT");
}

KLogUDP::~KLogUDP()
{
    debug("Destroy UDP\n");
}

QString KLogUDP::getSrcPort(void) const
{
    return QString::number(srcPort);
}

QString KLogUDP::getDstPort(void) const
{
    char b[64];
    struct servent *service;

    if ((service = getservbyport(htons(dstPort), NULL)) == NULL)
    {
        sprintf(b, "%d (unknown)", dstPort);
    }
    else
    {
        sprintf(b, "%s (%d)", service->s_name, dstPort);
    }

    return QString(b);
}

int KLogUDP::getDstPortNum(void) const
{
    return dstPort;
}

int KLogUDP::getSrcPortNum(void) const
{
    return srcPort;
}

QString KLogUDP::toString(bool full) const
{
    char b[64];
    struct servent *service;

    if ((service = getservbyport(htons(dstPort), NULL)) == NULL)
    {
        sprintf(b, "(%d) to %d(unknown)", srcPort, dstPort);
    }
    else
    {
        sprintf(b, "(%d) to %s(%d)", srcPort, service->s_name, dstPort);
    }

    return KLogIP::toString(full) + b;
}

// eof
