/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef KLOGCONFIG_H
#define KLOGCONFIG_H

#include <qfont.h>
#include <qnamespace.h>
#include <qstringlist.h>

#include <kconfig.h>

#define _POLLTIME      1
#define _PAUSETIME     60
#define _COMMAND       ""
#define _FILENAME      "/var/log/kernel"
#define _BUFFSIZE      1000
#define _COMMANDDIALOG 1
#define _SAVERAW       1

#define SOURCE_HOST       0
#define SOURCE_WHOIS      1
#define SOURCE_PING       2
#define SOURCE_TRACEROUTE 3
#define SOURCE_PORT       4
#define DEST_HOST         5
#define DEST_WHOIS        6
#define DEST_PING         7
#define DEST_TRACEROUTE   8
#define DEST_PORT         9
#define CUSTOM_COMMAND   10

#define	MAXNEWROWS   20

class KLogConfig
{
public:
    static KLogConfig *getConfig();
    void load();
    void save();
    void defaults();

    QString     FILENAME;
    int         POLLTIME;
    int         PAUSETIME;
    int         BUFFSIZE;
    QString     COMMAND;
    QFont       FONT;
    QFont       PRINTFONT;
    int         COMMANDDIALOG;
    bool        SAVERAW;
    QStringList StandardWidths;
    QStringList ColumnWidths;
    QStringList ColumnOrder;
    QSize       mainWinSize;
    QPoint      mainWinPos;
    int         SortColumn;
    int         SortAscending;
    int         DoubleClickAction;

private:
    KLogConfig();
    ~KLogConfig();
    KConfig *file;
    static  KLogConfig *me;
};

extern KLogConfig *klogconfig;

#endif
