/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */ 

#ifndef KLOGDIALOG_H
#define KLOGDIALOG_H

#include <kdialog.h>
#include "klogIP.h"

class KProcess;
class QLabel;
class KPushButton;
class QTextEdit;

class KLogDialog : public KDialog
{
Q_OBJECT

public:
    KLogDialog(bool isRunCommand, QWidget *parent=0, const char *name=0, bool modal=FALSE, WFlags fl = WDestructiveClose);
    ~KLogDialog();
    KPushButton* buttonCancel;
    void getHostName(const QString tempaddr="", bool sourceHost=FALSE);
    void runCommand(const KLogIP *packet=0, QString command="", bool showDialog=TRUE);

private slots:
    void childExited();
    void insertLine(const QString&);

    void slotReceivedStdout(const QString&);
    void slotReceivedStderr(const QString&);

    void slotReceivedStdout(const char*);
    void slotReceivedStderr(const char*);

private:
    KProcess  *proc;
    QString   stdoutbuf;
    QString   stderrbuf;
    bool      priorOutput;
    bool      _showDialog;
    bool      getRunLine;
    QString   _command;

    QTextEdit *runOutput;
    QLabel    *infoLabel;

protected slots:
    void slotReceivedStdout(KProcess *, char *buffer, int buflen);
    void slotReceivedStderr(KProcess *, char *buffer, int buflen);

signals:
    void receivedStdoutLine( const QString& line );
    void receivedStderrLine( const QString& line );
};

#endif
