/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef KLOGITEM_H
#define KLOGITEM_H

#define TIME_COL      0
#define PREFIX_COL    1
#define PROTOCOL_COL  2
#define IN_IFACE_COL  3
#define OUT_IFACE_COL 4
#define MAC_COL       5
#define S_ADDR_COL    6
#define S_PORT_COL    7
#define D_ADDR_COL    8
#define D_PORT_COL    9
#define FLAGS_COL     10

#include <klistview.h>

#include "klogIP.h"

class KLogItem: public KListViewItem
{
public:
    KLogItem(KListView *listbox, const KLogLine *line);
    const KLogIP *getPacket(void) const;
    virtual void paintCell(QPainter *p, const QColorGroup &cg,int col, int width, int align);
    virtual int compare(QListViewItem *i, int col, bool ascending) const;
    bool  isNew;
    int   srcIpNum[4];
    int   dstIpNum[4];
    int   srcPortNum;
    int   dstPortNum;
    unsigned long packetNumber;
    ~KLogItem();

private:
    const KLogLine *line;
    const KLogIP   *packet;
};

#endif

