/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef KLOGLINE_H
#define KLOGLINE_H

#include <qdatetime.h>
#include <qstring.h>

#include "klogIP.h"

class KLogIP;

class KLogLine
{
public:
    KLogLine(const QString);
    virtual ~KLogLine();

    const QString & toString(void) const;
    const KLogIP    *getPacket(void) const;
    const char      *getLine(void) const;

    const bool      isPacket(void) const;
    const QDate&    getDate(void) const;
    const QTime&    getTime(void) const;
    const QString&  getDateTime(void) const;
    QString         getPrefix(void) const;
    QString         getString(const char *) const;
    QString         getProto(void) const;
    QString         getHost(void) const;
    QString         getIP(const char *) const;
    int             getInt(const char *) const;
    bool            getBool(const char *) const;

private:
    void            parse(void);

    const QString   qline;
    const char      *logline;
    KLogIP          *packet;
    QDate           date;
    QTime           time;
    QString         datetime;
};

#endif
