/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef KLOGLIST_H
#define KLOGLIST_H

#include <qtimer.h>
#include <qthread.h>

#include <kprinter.h>

#include "klogconfig.h"
#include "klogitem.h"
#include "klogtail.h"
#include "klogtray.h"
#include "qtlist.h"

class KLogTray;
class KPopupMenu;

class KLogList: public QTlist
{
    Q_OBJECT;

public:
    KLogList(QString, QWidget * = 0);
    virtual ~KLogList();

    void    saveTo(QTextStream &);
    void    printTo(KPrinter &);
    void    thinking(void);
    void    running(void);
    void    markOldPackets();
    ulong   uncheckedPacketCount;
    ulong   totalPacketCount;
    void    applySettings(QString file, QWidget *parent);

//public slots:
    void    saveColLayout();

private:
    QString getLogLine(void);
    void    keyPressEvent(QKeyEvent *);
    bool    addNew(void);
    bool    eventFilter ( QObject *o, QEvent *e );
    int     restoreColLayout();

signals:
    void    sigHide(void);
    void    sigShow(bool);
    void    sigExit(void);

private slots:
    void    slotTimer(void);
    void    slotHide(void);
    void    slotClear(void);
    void    slotPause(void);
    void    slotClick(QListViewItem *);
    void    slotOpen(QListViewItem *);
    void    slotExit(void);
    void    slotSourceHostName(QListViewItem *);
    void    slotDestHostName(QListViewItem *);
    void    slotSourceWhois(QListViewItem *);
    void    slotDestWhois(QListViewItem *);
    void    slotSourcePing(QListViewItem *);
    void    slotDestPing(QListViewItem *);
    void    slotSourceTraceroute(QListViewItem *);
    void    slotDestTraceroute(QListViewItem *);
    int     slotToggleColumn(int id, int mode = -1);
    void    slotSANSSrcPortInfo(QListViewItem *);
    void    slotSANSDstPortInfo(QListViewItem *);
    void    rightButtonPressed( QListViewItem *, const QPoint &, int );

private:
    enum    { THINKING, RUNNING } state;
    int     pauseCount;
    int     showCount;
    int     pollCount;
    ulong   oldestPacket;

    QTimer     *timer;
    QMutex     mutex;
    KLogTail   *tailer;
    KLogConfig *config;
    KLogTray   *tray;
    KPopupMenu *headerPopup;
};

#endif
