/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>

#include <kfontrequester.h>
#include <klocale.h>
#include <kurlrequester.h>

#include "debug.h"
#include "klogsetup.h"

KLogSetup::KLogSetup(QWidget *parent): KDialogBase ( KDialogBase::Swallow,
                 i18n("Configure"),
                 KDialogBase::Ok | KDialogBase::Cancel | KDialogBase::Default,
                 KDialogBase::Ok,
                 parent,
                 "configdialog" )
{
    dialog = new QTsetup(this);
    setMainWidget(dialog);

    dialog->doubleClickAction->insertItem("Get Source Host Name", SOURCE_HOST);
    dialog->doubleClickAction->insertItem("Whois Source Host", SOURCE_WHOIS);
    dialog->doubleClickAction->insertItem("Ping Source Host", SOURCE_PING);
    dialog->doubleClickAction->insertItem("Traceroute Source Host", SOURCE_TRACEROUTE);
    dialog->doubleClickAction->insertItem("Check Source Port Info at SANS...", SOURCE_PORT);
    dialog->doubleClickAction->insertItem("Get Destination Host Name", DEST_HOST);
    dialog->doubleClickAction->insertItem("Whois Destination Host", DEST_WHOIS);
    dialog->doubleClickAction->insertItem("Ping Destination Host", DEST_PING);
    dialog->doubleClickAction->insertItem("Traceroute Destination Host", DEST_TRACEROUTE);
    dialog->doubleClickAction->insertItem("Check Destination Port Info at SANS...", DEST_PORT);
    dialog->doubleClickAction->insertItem("Run Custom Command", CUSTOM_COMMAND);

    dialog->pollinterval->setRange(1, 60);
    dialog->pauseinterval->setRange(60, 600);
    dialog->buffersize->setRange(1000, 100000);

    dialog->filename->setURL(klogconfig->FILENAME);
    dialog->pollinterval->setValue(klogconfig->POLLTIME);
    dialog->pauseinterval->setValue(klogconfig->PAUSETIME);
    dialog->buffersize->setValue(klogconfig->BUFFSIZE);
    dialog->saveraw->setChecked(klogconfig->SAVERAW);
    dialog->command->setText(klogconfig->COMMAND);
    dialog->fontbutton->setFont(klogconfig->FONT);
    dialog->printfontbutton->setFont(klogconfig->PRINTFONT);
    dialog->commanddialog->setChecked(klogconfig->COMMANDDIALOG == 1);
    dialog->doubleClickAction->setCurrentItem(klogconfig->DoubleClickAction);

    // Log File Tab
    setTabOrder( dialog->filename, dialog->pollinterval );
    setTabOrder( dialog->pollinterval, dialog->pauseinterval );
    setTabOrder( dialog->pauseinterval, dialog->buffersize );
    setTabOrder( dialog->buffersize, dialog->saveraw );

    // Display Tab
    setTabOrder( dialog->fontbutton, dialog->printfontbutton );

    // Command Tab
    setTabOrder( dialog->doubleClickAction, dialog->command );
    setTabOrder( dialog->command, dialog->commanddialog );

    adjustSize();

    connect(this, SIGNAL(okClicked(void)), this, SLOT(okSlot(void)));
    connect(this, SIGNAL(cancelClicked(void)), this, SLOT(cancelSlot(void)));
    connect(this, SIGNAL(defaultClicked(void)), this, SLOT(defaultSlot(void)));
}

KLogSetup::~KLogSetup()
{
    debug("Destroy KLogSetup\n");
}

void KLogSetup::okSlot()
{
    debug("OK\n");
    klogconfig->FILENAME = dialog->filename->url();
    klogconfig->POLLTIME = dialog->pollinterval->value();
    klogconfig->PAUSETIME = dialog->pauseinterval->value();
    klogconfig->BUFFSIZE = dialog->buffersize->value();
    klogconfig->SAVERAW = dialog->saveraw->isChecked();
    klogconfig->COMMAND = dialog->command->text();
    klogconfig->DoubleClickAction = dialog->doubleClickAction->currentItem();
    klogconfig->FONT = dialog->fontbutton->font();
    klogconfig->PRINTFONT = dialog->printfontbutton->font();

    klogconfig->COMMANDDIALOG = (dialog->commanddialog->isChecked() ? 1 : 0);

    klogconfig->save();
    accept();
}

void KLogSetup::applySlot()
{
    okSlot();
}

void KLogSetup::cancelSlot()
{
    debug("Cancel\n");
    reject();
}

void KLogSetup::defaultSlot()
{
    debug("Setting defaults\n");
    klogconfig->defaults();

    dialog->filename->setURL(klogconfig->FILENAME);
    dialog->pollinterval->setValue(klogconfig->POLLTIME);
    dialog->pauseinterval->setValue(klogconfig->PAUSETIME);
    dialog->buffersize->setValue(klogconfig->BUFFSIZE);
    dialog->saveraw->setChecked(klogconfig->SAVERAW);
    dialog->command->setText(klogconfig->COMMAND);
    dialog->fontbutton->setFont(klogconfig->FONT);
    dialog->printfontbutton->setFont(klogconfig->PRINTFONT);
    dialog->commanddialog->setChecked(klogconfig->COMMANDDIALOG == 1);
    dialog->doubleClickAction->setCurrentItem(klogconfig->DoubleClickAction);
}

// eof
