/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef KLOGSETUP
#define KLOGSETUP

#include <kdialogbase.h>

#include "klogconfig.h"
#include "qtsetup.h"

class KLogSetup: public KDialogBase
{
    Q_OBJECT;

public:
    KLogSetup(QWidget *parent);
    virtual ~KLogSetup();

    KLogConfig  *config;

private:
    QTsetup     *dialog;

private slots:
    void        okSlot(void);
    void        cancelSlot(void);
    void        defaultSlot(void);
    void        applySlot(void);
};

#endif
