/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef KLOGTAIL_H
#define KLOGTAIL_H

#include <sys/types.h>

#include <qstring.h>

#include "klogline.h"

class KLogTail
{
public:
    KLogTail(const char *);
    virtual ~KLogTail();

    const      KLogLine *getLogLine(void);
    int        setup();

private:
    int        fd;
    ino_t      inode;
    off_t      size;
    QString    path;
    bool       statFile(void);
};

#endif
