/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#include <qtooltip.h>

#include <kglobal.h>
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <kpushbutton.h>
#include <kuniqueapplication.h>

#include "debug.h"
#include "klogtray.h"

KLogTray::KLogTray(KLogWatch *watch, KLogList *list) : KSystemTray(watch)
{
    KIconLoader *i = KGlobal::iconLoader();
    KPopupMenu *filePopup = contextMenu();
    kloglist = list;

    filePopup->insertItem(i->loadIcon("configure.xpm", KIcon::Small),
                "S&etup", watch, SLOT(slotSetup()), CTRL+Key_C);

    tickicon = UserIcon("tick22");
    plingicon = UserIcon("pling22");

    setTrayIcon(false);
    show();
}

KLogTray::~KLogTray(void)
{
}

void KLogTray::mousePressEvent(QMouseEvent *e)
{
    KSystemTray::mousePressEvent(e); // do the show/hide

    if (e->button() == Qt::LeftButton)
    {
        if (kloglist->isVisible())   // we're now visible
        {
            kloglist->thinking();
        }
        else
        {
            kloglist->hideButton->animateClick();
        }
    }
}

void KLogTray::setTrayIcon(bool newPacket)
{
    if (newPacket)
    {
        debug("Showing new tray\n");
        setPixmap(plingicon);
    }
    else
    {
        debug("Showing empty tray\n");
        setPixmap(tickicon);
    }

    setTooltip();
}

void KLogTray::setTooltip()
{
    QString tem1 = QString::number(kloglist->uncheckedPacketCount);
    QString tem2 = QString::number(kloglist->totalPacketCount);
    QString tip = "New packets: " + tem1 + "\nTotal packets: " + tem2;
    QToolTip::add(this, tip);
}

// eof
