/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef KLOGTRAY_H
#define KLOGTRAY_H

#include <ksystemtray.h>

#include "kloglist.h"
#include "klogwatch.h"

class KLogWatch;
class KLogList;

class KLogTray : public KSystemTray
{
public:
    KLogTray(KLogWatch *, KLogList *);
    ~KLogTray(void);
    void       mousePressEvent(QMouseEvent *e);
    void       setTrayIcon(bool newPacket);
    void       setTooltip();

private:
    KLogList   *kloglist;
    QPixmap    tickicon;
    QPixmap    plingicon;
};

#endif
