/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef KLOGWATCH_H
#define KLOGWATCH_H

#include <kmainwindow.h>
#include <kmenubar.h>

#include "kloglist.h"

class KLogList;

class KLogWatch: public KMainWindow
{
    Q_OBJECT;

public:
    KLogWatch(const char *logfile);
    virtual ~KLogWatch();

private slots:
    void       slotShow(bool);
    void       slotHide(void);
    void       slotSave(void);
    void       slotSetup(void);
    void       slotPrint(void);
    void       slotExit(void);
    void       slotSaveConfig(void);

private:
    KMenuBar   *menubar;
    KLogList   *kloglist;
    QString    file;

protected:
  virtual void resizeEvent(QResizeEvent*);
  virtual void moveEvent(QMoveEvent*);
  virtual void showEvent(QShowEvent*);
  virtual void closeEvent( QCloseEvent *e );
};

#endif
