/*
 * Klogwatch, Netfilter log monitor
 *
 * Copyright (C) 2004 Nick Battle <nick.battle@freeuk.com>
 * Copyright (C) 2006 John Stamp <jstamp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#include <kcmdlineargs.h>
#include <klocale.h>
#include <kuniqueapplication.h>

#include "klogpid.h"
#include "klogwatch.h"

static KCmdLineOptions options[] =
{
    { "f <file>", "The file to monitor", 0 },
    { "d",        "Debug - no daemon mode, and show window", 0 },
    { "k",        "Kill all running instances", 0 },
    { "p",        "Popup window of any hidden process", 0 },
    { 0, 0, 0 }
};

bool debugOn = false;    // See debug.h
KLogConfig *klogconfig = NULL;

int main(int argc, char *argv[])
{
    KCmdLineArgs::init(argc, argv, "klogwatch",
#if KDE_IS_VERSION(3,2,2)
    I18N_NOOP("KLogWatch"),
#endif
    "A simple Netfilter log file monitor", VERSION);

    KCmdLineArgs::addCmdLineOptions(options);
    KUniqueApplication::addCmdLineOptions();
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    debugOn = args->isSet("d");

    if (args->isSet("k"))
    {
        return(KLogWatchKill(SIGTERM));
    }
    else if (args->isSet("p"))
    {
        return(KLogWatchKill(SIGUSR1));
    }
    else
    {
        KApplication *app;

        // KUniqueApplication daemonizes the program automatically
        // so we use KApplication if debug is set.

        if (args->isSet("d"))
        {
            app = new KApplication();
        }
        else
        {
            app = new KUniqueApplication();
        }

        KLogSigInit();
        klogconfig = KLogConfig::getConfig();
        QCString file;

        if (args->isSet("f"))
        {
            file = args->getOption("f");
            klogconfig->FILENAME = file;
        }
        else
        {
            file = klogconfig->FILENAME;
        }

        int rv = 0;

        KLogWatch *main = new KLogWatch(file);

        if (args->isSet("d"))
        {
            main->show();
        }

        rv = app->exec();

        return rv;
    }
    return 0;
}

// eof
