# Handle the incoming configuration files:
/sbin/depmod -a

# If the haldaemon user/group don't exist, add them:
if ! grep -q kvm /etc/group; then
        groupadd kvm
fi

config() {
  for infile in $1; do
  NEW="$infile"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
  done
}
config etc/udev/rules.d/60-kvm.rules.new

/etc/rc.d/rc.udev reload

( ln -s /usr/bin/qemu-system-x86_64 /usr/bin/qemu )