#ifndef DEF_HELPER
#define DEF_HELPER(ret, name, params) ret name params;
#endif

DEF_HELPER(void, helper_tb_flush, (void))

DEF_HELPER(void, helper_excp, (int, int))
DEF_HELPER(uint64_t, helper_amask, (uint64_t))
DEF_HELPER(uint64_t, helper_load_pcc, (void))
DEF_HELPER(uint64_t, helper_load_implver, (void))
DEF_HELPER(uint64_t, helper_rc, (void))
DEF_HELPER(uint64_t, helper_rs, (void))

DEF_HELPER(uint64_t, helper_addqv, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_addlv, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_subqv, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_sublv, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_mullv, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_mulqv, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_umulh, (uint64_t, uint64_t))

DEF_HELPER(uint64_t, helper_ctpop, (uint64_t))
DEF_HELPER(uint64_t, helper_ctlz, (uint64_t))
DEF_HELPER(uint64_t, helper_cttz, (uint64_t))

DEF_HELPER(uint64_t, helper_mskbl, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_insbl, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_mskwl, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_inswl, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_mskll, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_insll, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_zap, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_zapnot, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_mskql, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_insql, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_mskwh, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_inswh, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_msklh, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_inslh, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_mskqh, (int64_t, uint64_t))
DEF_HELPER(uint64_t, helper_insqh, (int64_t, uint64_t))

DEF_HELPER(uint64_t, helper_cmpbge, (uint64_t, uint64_t))

DEF_HELPER(uint64_t, helper_load_fpcr, (void))
DEF_HELPER(void, helper_store_fpcr, (uint64_t val))

DEF_HELPER(uint32_t, helper_f_to_memory, (uint64_t s))
DEF_HELPER(uint64_t, helper_memory_to_f, (uint32_t s))
DEF_HELPER(uint64_t, helper_addf, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_subf, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_mulf, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_divf, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_sqrtf, (uint64_t))

DEF_HELPER(uint64_t, helper_g_to_memory, (uint64_t s))
DEF_HELPER(uint64_t, helper_memory_to_g, (uint64_t s))
DEF_HELPER(uint64_t, helper_addg, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_subg, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_mulg, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_divg, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_sqrtg, (uint64_t))

DEF_HELPER(uint32_t, helper_s_to_memory, (uint64_t s))
DEF_HELPER(uint64_t, helper_memory_to_s, (uint32_t s))
DEF_HELPER(uint64_t, helper_adds, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_subs, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_muls, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_divs, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_sqrts, (uint64_t))

DEF_HELPER(uint64_t, helper_addt, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_subt, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_mult, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_divt, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_sqrtt, (uint64_t))

DEF_HELPER(uint64_t, helper_cmptun, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_cmpteq, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_cmptle, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_cmptlt, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_cmpgeq, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_cmpgle, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_cmpglt, (uint64_t, uint64_t))

DEF_HELPER(uint64_t, helper_cmpfeq, (uint64_t))
DEF_HELPER(uint64_t, helper_cmpfne, (uint64_t))
DEF_HELPER(uint64_t, helper_cmpflt, (uint64_t))
DEF_HELPER(uint64_t, helper_cmpfle, (uint64_t))
DEF_HELPER(uint64_t, helper_cmpfgt, (uint64_t))
DEF_HELPER(uint64_t, helper_cmpfge, (uint64_t))

DEF_HELPER(uint64_t, helper_cpys, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_cpysn, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_cpyse, (uint64_t, uint64_t))

DEF_HELPER(uint64_t, helper_cvtts, (uint64_t))
DEF_HELPER(uint64_t, helper_cvtst, (uint64_t))
DEF_HELPER(uint64_t, helper_cvttq, (uint64_t))
DEF_HELPER(uint32_t, helper_cvtqs, (uint64_t))
DEF_HELPER(uint64_t, helper_cvtqt, (uint64_t))
DEF_HELPER(uint64_t, helper_cvtqf, (uint64_t))
DEF_HELPER(uint64_t, helper_cvtgf, (uint64_t))
DEF_HELPER(uint64_t, helper_cvtgq, (uint64_t))
DEF_HELPER(uint64_t, helper_cvtqg, (uint64_t))
DEF_HELPER(uint64_t, helper_cvtlq, (uint64_t))
DEF_HELPER(uint64_t, helper_cvtql, (uint64_t))
DEF_HELPER(uint64_t, helper_cvtqlv, (uint64_t))
DEF_HELPER(uint64_t, helper_cvtqlsv, (uint64_t))

#if !defined (CONFIG_USER_ONLY)
DEF_HELPER(void, helper_hw_rei, (void))
DEF_HELPER(void, helper_hw_ret, (uint64_t))
DEF_HELPER(uint64_t, helper_mfpr, (int, uint64_t))
DEF_HELPER(void, helper_mtpr, (int, uint64_t))
DEF_HELPER(void, helper_set_alt_mode, (void))
DEF_HELPER(void, helper_restore_mode, (void))

DEF_HELPER(uint64_t, helper_ld_virt_to_phys, (uint64_t))
DEF_HELPER(uint64_t, helper_st_virt_to_phys, (uint64_t))
DEF_HELPER(void, helper_ldl_raw, (uint64_t, uint64_t))
DEF_HELPER(void, helper_ldq_raw, (uint64_t, uint64_t))
DEF_HELPER(void, helper_ldl_l_raw, (uint64_t, uint64_t))
DEF_HELPER(void, helper_ldq_l_raw, (uint64_t, uint64_t))
DEF_HELPER(void, helper_ldl_kernel, (uint64_t, uint64_t))
DEF_HELPER(void, helper_ldq_kernel, (uint64_t, uint64_t))
DEF_HELPER(void, helper_ldl_data, (uint64_t, uint64_t))
DEF_HELPER(void, helper_ldq_data, (uint64_t, uint64_t))
DEF_HELPER(void, helper_stl_raw, (uint64_t, uint64_t))
DEF_HELPER(void, helper_stq_raw, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_stl_c_raw, (uint64_t, uint64_t))
DEF_HELPER(uint64_t, helper_stq_c_raw, (uint64_t, uint64_t))
#endif
