#!/bin/sh

function config() {
	NEW="$1"
	OLD="`dirname $NEW`/`basename $NEW .new`"

	# If there's no config file by that name, mv it over:
	if [ ! -r $OLD ]; then
		echo "--- Renaming $NEW to $OLD"
		mv $NEW $OLD
	elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
		# toss the redundant copy
		echo "--- Deleting $NEW"
		rm $NEW
	else
		# Otherwise, we leave the .new copy for the admin to consider...
		echo "--- Leaving $NEW for you to replace $OLD"
	fi


}

for i in /etc/pam.d/*.new
do
	if [ -f $i ]
	then
		config $i
	fi
done
( cd lib ; rm -rf libpam_misc.so )
( cd lib ; ln -sf libpam_misc.so.0.81.3 libpam_misc.so )
( cd lib ; rm -rf libpamc.so.0 )
( cd lib ; ln -sf libpamc.so.0.81.0 libpamc.so.0 )
( cd lib ; rm -rf libpamc.so )
( cd lib ; ln -sf libpamc.so.0.81.0 libpamc.so )
( cd lib ; rm -rf libpam.so.0 )
( cd lib ; ln -sf libpam.so.0.81.10 libpam.so.0 )
( cd lib ; rm -rf libpam_misc.so.0 )
( cd lib ; ln -sf libpam_misc.so.0.81.3 libpam_misc.so.0 )
( cd lib ; rm -rf libpam.so )
( cd lib ; ln -sf libpam.so.0.81.10 libpam.so )
