/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl							   *
 *   k.zawadyl@gmail.com												   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "configadvanced.h"
#include "mconfiguration.h"

#include <qradiobutton.h>
#include <qlineedit.h>
#include <qbuttongroup.h>

ConfigAdvanced::ConfigAdvanced(QWidget *parent, const char *name)
    :ConfigAdvancedBase(parent, name)
{
	updateValues();
}

void ConfigAdvanced::updateValues()
{
	switch( Config().defaultRegExp )
	{
		case MConfiguration::MetaLog:
			defaultRegExpMetaLogRadio->setChecked( true );
			break;
		case MConfiguration::SysLog:
			defaultRegExpSysLogRadio->setChecked( true );
			break;
		default:
			customRegExpRadio->setChecked( true );
			break;
	}
	
	customRegExpEdit->setText( Config().customRegExp );
	enableSoundsCheckBox->setChecked( Config().soundEnabled );
	soundPlayerEdit->setText( Config().soundPlayerCmd );
}

void ConfigAdvanced::updateConfig()
{
	if( defaultRegExpMetaLogRadio->isChecked() )
		Config().defaultRegExp = MConfiguration::MetaLog;
	else
	if( defaultRegExpSysLogRadio->isChecked() )
		Config().defaultRegExp = MConfiguration::SysLog;
	else
		Config().defaultRegExp = MConfiguration::NoLog;

	Config().customRegExp = customRegExpEdit->text();
	Config().soundEnabled = enableSoundsCheckBox->isChecked();
	Config().soundPlayerCmd = soundPlayerEdit->text();
}
#include "configadvanced.moc"
