/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl							   *
 *   k.zawadyl@gmail.com												   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "configtriggers.h"
#include "mconfiguration.h"
#include "triggeredit.h"

#include <qlistbox.h>
#include <qpushbutton.h>

#include <kmessagebox.h>
#include <klocale.h>

ConfigTriggers::ConfigTriggers(QWidget *parent, const char *name)
    :ConfigTriggersBase(parent, name)
{
	connect( triggerListBox,SIGNAL(selected(QListBoxItem*)),this,SLOT(editTrigger(QListBoxItem*)));
	connect( triggerAddButton, SIGNAL( clicked() ), this, SLOT( addTrigger() ) );
	connect( triggerEditButton, SIGNAL( clicked() ), this, SLOT( editCurrentTrigger() ) );
	connect( triggerDeleteButton, SIGNAL( clicked() ), this, SLOT( deleteTrigger() ) );
	connect( triggerUpButton, SIGNAL( clicked() ), this, SLOT( moveCurrentTriggerUp() ) );
	connect( triggerDownButton, SIGNAL( clicked() ), this, SLOT( moveCurrentTriggerDown() ) );
	
	updateValues();
}

void ConfigTriggers::updateValues()
{
	triggerListBox->clear();
	triggerList = Config().triggerList;
	MTrigger *mt;
	QPtrListIterator<MTrigger> it( triggerList );
	while ( (mt=it.current()) )
	{
		triggerListBox->insertItem( mt->getPixmap(), mt->title() );
		++it;
	}
}

void ConfigTriggers::updateConfig()
{
	Config().triggerList = triggerList;
}

void ConfigTriggers::addTrigger()
{
	MTrigger *mt = new MTrigger();
	TriggerEdit te( this, mt );
	int result = te.exec();
	
	if( result == QDialog::Accepted )
	{
		te.setTrigger( mt );
		
		if( !mt->getSenderName() && !mt->getMessageText() )
		{
			delete mt;
			return;
		}
		
		triggerListBox->insertItem( mt->getPixmap(), mt->title() );
		triggerList.append(mt);
	}
	else
		delete mt;
}

void ConfigTriggers::deleteTrigger()
{
	QListBoxItem *it = triggerListBox->selectedItem();
	if( !it )
	{
		KMessageBox::error( this, i18n("You have to select a trigger"), i18n("MetaMonitor") );
		return;
	}
	
	if( KMessageBox::questionYesNo( this, i18n("Are you sure to delete this trigger?"), i18n("MetaMonitor") ) ==  KMessageBox::Yes )
	{
		MTrigger *mt = getTrigger( it );
		triggerListBox->takeItem( it );
		triggerList.remove( mt );
	}
}

void ConfigTriggers::editTrigger(QListBoxItem *it)
{
	MTrigger *mt = getTrigger( it );
	
	TriggerEdit te( this, mt );
	int result = te.exec();
	
	if( result == QDialog::Accepted )
	{
		te.setTrigger( mt );
		triggerListBox->changeItem( mt->getPixmap(), mt->title(), triggerListBox->index(it) );
	}
}

void ConfigTriggers::editCurrentTrigger()
{
	QListBoxItem *it = triggerListBox->selectedItem();
	if( !it )
	{
		KMessageBox::error( this, i18n("You have to select a trigger"), i18n("MetaMonitor") );
		return;
	}
	
	editTrigger( it );
}

MTrigger * ConfigTriggers::getTrigger( QListBoxItem *item )
{
	int i = 0;
	i = triggerListBox->index( item );
	return triggerList.at( i );
}

void ConfigTriggers::moveCurrentTriggerDown()
{
	QListBoxItem *it = triggerListBox->selectedItem();
	if( !it )
	{
		KMessageBox::error( this, i18n("You have to select a trigger"), i18n("MetaMonitor") );
		return;
	}
	
	if( !it->next() )
	{
		KMessageBox::error( this, i18n("Cannot move trigger lower"), i18n("MetaMonitor") );
		return;
	}
	
	int idx = triggerListBox->index( it );
	triggerListBox->takeItem( it );
	triggerListBox->insertItem( it, idx+1 );
	triggerListBox->clearSelection();
	triggerListBox->setSelected( it, true );
	triggerListBox->setCurrentItem( it );
	MTrigger *mt = triggerList.take( idx );
	triggerList.insert( idx+1, mt );
}

void ConfigTriggers::moveCurrentTriggerUp()
{
	QListBoxItem *it = triggerListBox->selectedItem();
	if( !it )
	{
		KMessageBox::error( this, i18n("You have to select a trigger"), i18n("MetaMonitor") );
		return;
	}
	
	if( !it->prev() )
	{
		KMessageBox::error( this, i18n("Cannot move trigger higher"), i18n("MetaMonitor") );
		return;
	}
	
	int idx = triggerListBox->index( it );
	triggerListBox->takeItem( it );
	triggerListBox->insertItem( it, idx-1 );
	triggerListBox->clearSelection();
	triggerListBox->setSelected( it, true );
	triggerListBox->setCurrentItem( it );
	MTrigger *mt = triggerList.take( idx );
	triggerList.insert( idx-1, mt );
}

#include "configtriggers.moc"
