/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl                               *
 *   k.zawadyl@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CONFIGURE_H
#define CONFIGURE_H

#include <qwidget.h>
#include <kdialogbase.h>

class ConfigGeneral;
class ConfigTriggers;
class ConfigAdvanced;
class ConfigThemes;

/**
 * @class Configure
 * 
 * Configure window's class
 * 
 * @author Krzysztof Zawadyl
 */
class Configure : public KDialogBase
{
    Q_OBJECT
public:
    Configure( QWidget *parent = 0, const char *name = 0 );
    ~Configure();

public slots:
	void				updateDialog();
	void				updateConfig();

private:
	ConfigGeneral *		mConfigGeneral;
	ConfigTriggers *	mConfigTriggers;
	ConfigAdvanced *	mConfigAdvanced;
	ConfigThemes *		mConfigThemes;
};

#endif
