/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl                               *
 *   k.zawadyl@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILEMONITOR_H
#define FILEMONITOR_H

#include "metamonitor.h"

#include <qobject.h>
#include <qstring.h>
#include <qptrlist.h>
#include <qfile.h>
#include <qtimer.h>

class Message;
class MFile;

/**
 * @class FileMonitor
 * @brief Single file monitor object
 * 
 * Every single FileMonitor object can monitor one file. It 'looks' every interval
 * if there are new lines in the file. If yes then the new message object is created, 
 * added to list and popped to user.
 * 
 * @author Krzysztof Zawadyl
 */
class FileMonitor : public QObject
{
Q_OBJECT

public:
	FileMonitor( MetaMonitor *parent, const QString &fileName, int interval );
	virtual ~FileMonitor();
	
	void			unsetFile();
	
public slots:
	void			changeInterval(int interval);
	void			update();
	void			fileReopened();
	void			fileLost();
	
signals:
	void			messageReceived(Message *m);
	
private:	
	bool			init(bool quiet);
	
	MetaMonitor *	parent;
	MFile *			mFile;
	int				mHandle;
	int				mUpdateInterval;
	QTimer *		mTimer;
};

#endif
