/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl                               *
 *   k.zawadyl@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "metamonitor.h"
#include "message.h"

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] = I18N_NOOP("Log monitoring tool for KDE");
static const char version[] = VERSION;

int main(int argc, char **argv)
{
	KAboutData about("metamonitor", I18N_NOOP("MetaMonitor"), version, description,
					 KAboutData::License_GPL, "(C) 2005 Krzysztof Zawadyl", 0, 0, "kzawadyl@users.sourceforge.net");
	about.addAuthor( "Krzysztof Zawadyl", 0, "k.zawadyl@gmail.com" );
	KCmdLineArgs::init(argc, argv, &about);
    
	KApplication app;
	MetaMonitor m;
	m.show();
	
	return app.exec();
}

