/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl                               *
 *   k.zawadyl@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MESSAGE_H
#define MESSAGE_H

#include <qstring.h>
#include <qfont.h>
#include <qcolor.h>

/**
 * @class Message
 *
 * Single message's class
 * @author Krzysztof Zawadyl
 */
class Message
{
public:
    Message( const QString &from, const QString &txt );
    ~Message();

	QString 	getFrom();
	QString 	getText();
	QString 	getTime();
	void		setDate( const QString &d );
	void		setLifetime( int lt ) { mLifetime = lt; };
	int			getLifetime() { return mLifetime; };
	void		setShowPopup( bool sp ) { mPopup = sp; };
	bool		showPopup() { return mPopup; };
	void 		setTextColor( QColor c );
	QColor	*	getTextColor();
	void		setFont( QFont f ) { mFont = f; };
	QFont		getFont() { return mFont; };
	void		setIcon( QString i ) { mIcon = i; };
	QString		getIcon() { return mIcon; };
	QString		getCommand();
	QString		getButtonsLabel();
	void		setCommand( QString cmd, QString button );

private:
	QString 	mFrom;
	QString		mText;
	QString 	mTime;
	bool		mPopup;
	QString		mIcon;
	QFont		mFont;
	QColor	*	mColor;
	int			mLifetime;
	QString		mCommand;
	QString		mButtonsLabel;
};

#endif
