/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl                               *
 *   k.zawadyl@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MESSAGETABLE_H
#define MESSAGETABLE_H

#include "messagestablebase.h"

class KPopupMenu;
class MetaMonitor;
class Message;

/**
 * @class MessageTable
 * 
 * The window with messages list
 * 
 * @author Krzysztof Zawadyl
 */
class MessageTable : public MessageTableBase
{
Q_OBJECT

public:
	MessageTable( MetaMonitor *parent = 0, const char *name = 0 );
	~MessageTable();

	void		addMessage( Message *m );
		
private:
	KPopupMenu* menu;
	
public slots:
	void 		copySelected();
	void 		invertSelection();
	void 		selectAll();
	void		deleteMessages();
	
private slots:
	void 	showMenu(QListViewItem *item, const QPoint &pnt, int col);
};

#endif
