//
// C++ Interface: mfile
//
// Description: This is the modified code of klogtail.h from klogwatch-1.8.3 (GPL)
//
// Original author(s): 
// Nick Battle <nick.battle@freeuk.com> - Original author
// John Stamp <jstamp@users.sourceforge.net> - Enhancements in 1.7 and 1.8
//
// Added to MetaMonitor by Krzysztof Zawadyl <kzawadyl@gmail.com>
//
#ifndef MFILE_H
#define MFILE_H

#include <qobject.h>
#include <qstring.h>


class MFile : public QObject
{
Q_OBJECT
		
public:
    MFile(QString);
    ~MFile();
	
	bool	open();
	void	close();
	bool	isOpen() { return mfopen; };
	void 	goToEnd();
	QString getLogLine();
	QString errorString() { return error; };
	QString name() { return path; };

signals:
	void	lost();
	void	reOpened();
	
private:
	bool 	statFile();
	
	int 	fd;
	ino_t 	inode;
	off_t 	size;
	QString path;
	QString error;
	bool	mfopen;
};

#endif
