/***************************************************************************
 *   Copyright (C) 2005 by Krzysztof Zawadyl                               *
 *   k.zawadyl@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MTRIGGER_H
#define MTRIGGER_H

#include "message.h"

#include <qobject.h>
#include <qstring.h>
#include <qcolor.h>
#include <qfont.h>
#include <qpixmap.h>

class MTrigger : public QObject
{
Q_OBJECT
public:
	MTrigger();
    ~MTrigger();
	
	enum CompType { ExactComp = 0, ContainComp = 1, RegExp = 2 };
	
	QString		title();
	QPixmap		getPixmap();
	QString		getSenderName();
	QString		getMessageText();
	bool		check( Message *m );
	void		perform( Message *m );
	void		playSoundFile();
	
	// events
	bool		checkSenderName;
	QString 	senderName;
	CompType 	senderCompType;
	bool		checkMessageText;
	QString		messageText;
	CompType	messageCompType;
	
	// actions
	bool		dontShowPopups;
	bool		setPopupsTextColor;
	QColor		popupsTextColor;
	bool		setPopupsFont;
	QFont		popupsFont;
	bool		setPopupsLifeTime;
	int			popupsLifeTime;
	bool		setCustomIcon;
	QString		customIcon;
	bool		playSound;
	QString		soundFile;
	bool		runCommand;
	QString		command;
	QString		buttonsLabel;
};

#endif
